package com.yeejoin.amos.boot.module.statistics.api.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamForDetailDto;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 大屏指标管理下钻Mapper 接口
 *
 * @author maxy
 * @date 2024-11-05
 */
@Mapper
public interface ZBGLStatisticsMapper {
    List<Map<String,String>> getTypeList(@Param("type") String type);
    Long getDTGZYYZBFXChartData(@Param("dpFilterParamForDetailDto") DPFilterParamForDetailDto dpFilterParamForDetailDto);

    List<Map<String, Object>> getDTGZYYZBFXPageData(@Param("dpFilterParamForDetailDto") DPFilterParamForDetailDto dpFilterParamForDetailDto);

    Long getDTKRSJCSFXChartData(@Param("dpFilterParamForDetailDto") DPFilterParamForDetailDto dpFilterParamForDetailDto);

    List<Map<String, Object>> getDTKRSJCSFXPageData(@Param("dpFilterParamForDetailDto") DPFilterParamForDetailDto dpFilterParamForDetailDto);

    Map<String, Long> getKRJYYDQKChartData(@Param("dpFilterParamForDetailDto") DPFilterParamForDetailDto dpFilterParamForDetailDto, @Param("time") String time);

    Map<String,Long> getAYHLXYHSLPMChartData(@Param("dpFilterParamForDetailDto") DPFilterParamForDetailDto dpFilterParamForDetailDto);

    List<Map<String,Long>> getAYHLXYHSLPMPageData(@Param("dpFilterParamForDetailDto") DPFilterParamForDetailDto dpFilterParamForDetailDto);

    Map<String, Long> getDNZTDWYHPMChartData(@Param("dpFilterParamForDetailDto") DPFilterParamForDetailDto dpFilterParamForDetailDto, @Param("issueTypeList") List<String> issueTypeList);

    Page<Map<String,Object>> getUnitByOrgCode(@Param("page") Page page, @Param("dpFilterParamForDetailDto") DPFilterParamForDetailDto dpFilterParamForDetailDto);

    List<Map<String, Object>> getDNZTDWYHPMPageData(@Param("unitCodeList") List<String> unitCodeList);
}
