package com.yeejoin.amos.boot.module.tcm.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 检验信息表
 *
 * @author litw
 * @date 2021-09-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="TestInfoDto", description="检验信息表")
public class TestInfoDto  extends BaseDto {

   private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "电梯id")
    private String enevatorId;

    @ApiModelProperty(value = "最新检验时间")
    private Date testTime;

    @ApiModelProperty(value = "检验单位id")
    private String testUnitId;

    @ApiModelProperty(value = "检验单位")
    private String testUnit;

    @ApiModelProperty(value = "检验人员id")
    private String testPersonId;

    @ApiModelProperty(value = "检验人员")
    private String testPerson;

    @ApiModelProperty(value = "检验结论")
    private String testResult;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

}
