package com.yeejoin.amos.boot.module.tcm.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@AllArgsConstructor
@Getter
public enum PersonManageRoleEnum {
    /**
     * 人员管理角色枚举
     */
    // 业务办理人员 -> 6616
    code("人员管理角色字典code", 6616L),

    use("使用单位", 1735591519093547010L),
    agw("安装改造维修单位", 1735591458058035201L),
    // 需求调整 ： 检验检测机构拆分，对应的业务人员也拆分
    // 原先的数据：INSERT INTO "amos_project_1"."privilege_group" ("sequence_nbr", "group_name", "parent_id", "group_desc", "dims_seq", "level", "sort", "agency_code", "rec_date", "rec_user_id", "data_auth", "org_code", "group_type") VALUES (1735590873120399362, '检验检测业务办理人员', 0, '检验检测业务办理人员', 1742545453360115714, '0', 0, 'tzs', '2023-12-15 17:21:25', '8748712', NULL, '50', 'admin');
    // 删除下面的数据即可删除原先已经绑定的关系
    // SELECT * FROM "amos_project_1"."privilege_user_org_role" WHERE "role_seq" = '1735590873120399362';
    // jyjc("检验检测机构", 1735590873120399362L);

    jyjg("检验机构", 1947231335688990722L),
    jcjg("检测机构", 1947231362847109122L),

    /**
     * 风险报送员
     */
    risk_code("风险报送员", 6766L),
    fxbsy("风险报送员", 1953650773397106689L);
    String name;
    Long id;

    public static Map<Long, String> getName = new HashMap<>();
    public static Map<String, Long> getId = new HashMap<>();

    static {
        for (PersonManageRoleEnum e : PersonManageRoleEnum.values()) {
            getName.put(e.id, e.name);
            getId.put(e.name, e.id);
        }

    }
}
