package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpCollectorHistoryAllDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpCollectorHistoryMonthDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpCollectorHistoryYearDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.TdHygfJpCollectorHistoryDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpCollector;
import com.yeejoin.amos.boot.module.hygf.api.entity.TdHygfJpCollectorHistory;
import com.yeejoin.amos.boot.module.hygf.api.service.ITdHygfJpCollectorHistoryService;
import com.yeejoin.amos.boot.module.hygf.api.tdenginemapper.TdHygfJpCollectorHistoryMapper;
import com.yeejoin.amos.boot.module.hygf.api.util.TimeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.*;

/**
 * 户用光伏监盘采集器历史表服务实现类
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Service
public class TdHygfJpCollectorHistoryServiceImpl
		extends BaseService<TdHygfJpCollectorHistoryDto, TdHygfJpCollectorHistory, TdHygfJpCollectorHistoryMapper>
		implements ITdHygfJpCollectorHistoryService {

	@Autowired
	private JpCollectorServiceImpl jpCollectorServiceImpl;

	/**
	 * 分页查询
	 */
	public Page<TdHygfJpCollectorHistoryDto> queryForTdHygfJpCollectorHistoryPage(
			Page<TdHygfJpCollectorHistoryDto> page) {
		return this.queryForPage(page, null, false);
	}

	/**
	 * 列表查询 示例
	 */
	public List<TdHygfJpCollectorHistoryDto> dayList(long id, Date day) {
		JpCollector collector = jpCollectorServiceImpl.getById(id);

		if (collector != null) {
			List<TdHygfJpCollectorHistoryDto> list = this.baseMapper.dayList(collector.getSnCode(),
					collector.getThirdStationId(), TimeUtil.getStartTimeOfDay(day), TimeUtil.getEndTimeOfDay(day));
			if (!list.isEmpty()) {
				list.forEach(i -> {
					i.setTimeFormat(TimeUtil.minuteFormat(i.getTime()));
                    i.setSignalStrength(i.getSignalStrength()==null?null:i.getSignalStrength());

				});
			}
			return list;
		}
		return new ArrayList<>();
	}

	/**
	 * 列表查询 示例
	 */
	public List<JpCollectorHistoryMonthDto> monthList(long id, Date month) {
		JpCollector collector = jpCollectorServiceImpl.getById(id);
		Calendar cal = Calendar.getInstance();
		cal.setTime(month);
		String monthStr = String.valueOf(cal.get(Calendar.YEAR)) + "-" + String.valueOf(cal.get(Calendar.MONTH) + 1);
		if (collector != null) {
			return this.baseMapper.monthList(collector.getSnCode(), collector.getThirdStationId(), monthStr);
		}
		return new ArrayList<>();
	}

	/**
	 * 列表查询 示例
	 */
	public List<JpCollectorHistoryYearDto> yearList(long id, Date year) {
		JpCollector collector = jpCollectorServiceImpl.getById(id);
		Calendar cal = Calendar.getInstance();
		cal.setTime(year);
		String yearStr = String.valueOf(cal.get(Calendar.YEAR));
		if (collector != null) {
			return this.baseMapper.yearList(collector.getSnCode(), collector.getThirdStationId(), yearStr);
		}
		return new ArrayList<>();
	}

	/**
	 * 列表查询 示例
	 */
	public List<JpCollectorHistoryAllDto> allList(long id) {
		JpCollector collector = jpCollectorServiceImpl.getById(id);

		if (collector != null) {
			return this.baseMapper.allList(collector.getSnCode(), collector.getThirdStationId());
		}
		return new ArrayList<>();
	}




	@Async
	public Object syncData() {
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DATE, -1);
		Date dayTime = cal.getTime();
		int day = cal.get(Calendar.DATE);
		int month = cal.get(Calendar.MONTH) + 1;
		int year = cal.get(Calendar.YEAR);


		// 月表
		List<Map<String, Object>> monthList = this.baseMapper.dayToMonth(TimeUtil.getStartTimeOfDay(dayTime),
				TimeUtil.getEndTimeOfDay(dayTime));
		for (int i = 0; i < monthList.size(); i++) {
			monthList.get(i).put("created_time", dayTime.getTime() + i);
			monthList.get(i).put("day", day);
			monthList.get(i).put("year_month", year + "-" + month);
            monthList.get(i).put("sn_code", monthList.get(i).get("sn_code").toString().trim());

		}
		if (!monthList.isEmpty()) {
            List<JpCollectorHistoryMonthDto> listold=   this.baseMapper.monthList(null, null, year + "-" + month);

            if(listold!=null){

                for (Map<String, Object> map : monthList) {
                    for (JpCollectorHistoryMonthDto jpCollectorHistoryMonthDto : listold) {
                        if(map.get("third_station_id").toString().equals(jpCollectorHistoryMonthDto.getThirdStationId())
                                &&map.get("sn_code").toString().trim().equals(jpCollectorHistoryMonthDto.getSnCode().trim())
                                &&map.get("day").toString().equals(jpCollectorHistoryMonthDto.getDay())
                                &&map.get("year_month").toString().equals(jpCollectorHistoryMonthDto.getDay())

                        ){
                            map.put("created_time",jpCollectorHistoryMonthDto.getCreatedTime()) ;
                        }
                    }

                }

                this.baseMapper.updateMonth(monthList);

            }else{
                this.baseMapper.updateMonth(monthList);
            }

			// 年表
			List<Map<String, Object>> yearList = this.baseMapper.monthToYear(String.valueOf(year + "-" + month));
			List<JpCollectorHistoryYearDto> oldYearList = this.baseMapper.yearList(null, null, String.valueOf(year));
			for (int i = 0; i < yearList.size(); i++) {
				Map<String, Object> map = yearList.get(i);
				map.put("month", month);
				map.put("year", year);
				long time = dayTime.getTime() + i;
				for (JpCollectorHistoryYearDto dto : oldYearList) {
					if (dto.getThirdStationId() != null && dto.getSnCode() != null
							&& map.get("third_station_id") != null && map.get("sn_code") != null
							&& map.get("month") != null && map.get("year") != null
							&& dto.getThirdStationId().equals(map.get("third_station_id").toString())
							&& dto.getSnCode().trim().equals(map.get("sn_code").toString().trim())
							&& dto.getYear().equals(map.get("year").toString())
							&& dto.getMonth().equals(map.get("month").toString())) {
						time = dto.getCreatedTime();
						break;
					}
				}
				yearList.get(i).put("created_time", time);
			}
			if (!yearList.isEmpty()) {
				this.baseMapper.updateYear(yearList);
				// 总表
				List<Map<String, Object>> allList = this.baseMapper.yearToAll(String.valueOf(year));
				List<JpCollectorHistoryAllDto> oldAllList = this.baseMapper.allList(null, null);
				for (int i = 0; i < allList.size(); i++) {
					Map<String, Object> map = allList.get(i);
					map.put("year", year);
					long time = dayTime.getTime() + i;
					for (JpCollectorHistoryAllDto dto : oldAllList) {
						if (dto.getThirdStationId() != null && dto.getSnCode() != null
								&& map.get("third_station_id") != null && map.get("sn_code") != null
								&& map.get("year") != null
								&& dto.getThirdStationId().equals(map.get("third_station_id").toString())
								&& dto.getSnCode().trim().equals(map.get("sn_code").toString().trim())
								&& dto.getYear().equals(map.get("year").toString())) {
							time = dto.getCreatedTime();
							break;
						}
					}
					map.put("created_time", time);
				}
				if (!allList.isEmpty()) {
					this.baseMapper.updateAll(allList);
				}
			}
		}
		return null;
	}
}