package com.yeejoin.amos.boot.module.jxiop.biz.utils;

import java.util.ArrayList;
import java.util.Random;

public class MapUtils {
    private static final double EARTH_RADIUS = 63.781370; // 地球半径

    /**
     * 将经纬度转换为三维坐标
     * @param longitude 经度
     * @param latitude 纬度
     * @return 三维坐标数组 [x, y, z]
     */
    public static ArrayList<Double> geoTo3d(double longitude, double latitude) {
        ArrayList<Double> arrayList =new ArrayList<>();
        // 将经纬度转换为弧度
        double radLng = Math.toRadians(longitude);
        double radLat = Math.toRadians(latitude);

        // 计算x、y、z坐标值
        double x = EARTH_RADIUS * Math.cos(radLat) * Math.cos(radLng)+ 100 ;
        double y = EARTH_RADIUS * Math.cos(radLat) * Math.sin(radLng)+10;
        double z = EARTH_RADIUS * Math.sin(radLat)+2;
        arrayList.add(x);
        arrayList.add(y);
        arrayList.add(z);
        return arrayList;
    }
}
