package com.yeejoin.precontrol.common.config;

import com.yeejoin.precontrol.common.entity.*;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import com.yeejoin.precontrol.common.service.IBaseService;
import com.yeejoin.precontrol.common.utils.RedisUtil;
import com.yeejoin.precontrol.common.utils.TranslateUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @description: 字典缓存 本类禁止注释 否则影响整个系统
 * @author: duanwei
 * @date: 2020-07-17 08:55
 **/

@Slf4j
public class GlobalFormat implements InitializingBean {

    List<BaseEntity> transObject = new ArrayList<>();

    {
        transObject.add(new Person());
        transObject.add(new Company());
        transObject.add(new Project());
        transObject.add(new Task());
        transObject.add(new TechDocument());
    }

    @Autowired
    IBaseService iBaseService;
    @Autowired
    RedisUtil redisUtil;

    @Override
    public void afterPropertiesSet() throws Exception {
        transObject.forEach(transObject -> {
            List list = iBaseService.list(transObject, true, "id", "name");
            TranslateUtil.setDictionary(list, "name", redisUtil);
        });
        log.info("字典缓存加载完成!!!!!!!!!!");
    }

}
