package com.yeejoin.precontrol.common.param;

import com.yeejoin.precontrol.common.dto.BaseDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.Set;

import org.springframework.format.annotation.DateTimeFormat;

@Data
public class PersonParam extends BaseDto {
	private static final long serialVersionUID = 499419504344684048L;
	@ApiModelProperty(value = "姓名")
	private String name;
	@ApiModelProperty(value = "性别( 0-男 1-女 )")
	private Integer sex;
	@ApiModelProperty(value = "年龄起")
	private Integer ageStart;
	@ApiModelProperty(value = "年龄止")
	private Integer ageEnd;
	@ApiModelProperty(value = "手机号")
	private String phone;
	@ApiModelProperty(value = "身份证号")
	private String IDNumber;
	@ApiModelProperty(value = "公司id")
	private Long companyId;
	@ApiModelProperty(value = "公司名称")
	private String companyName;
	@ApiModelProperty(value = "项目id")
	private Long projectId;
	@ApiModelProperty(value = "项目id")
	private String projectName;
	@ApiModelProperty(value = "班组")
	private String departmentKey;
	@ApiModelProperty(value = "技能等级")
	private String skillLevelKey;
	@ApiModelProperty(value = "平台账号num")
	private String accountNumber;
	@ApiModelProperty(value = "岗位名称")
	private String postName;
	@ApiModelProperty(value = "成绩开始")
	private Integer examineScoreStart;
	@ApiModelProperty(value = "成绩结束")
	private Integer examineScoreEnd;
	@ApiModelProperty(value = "现学历")
	private String educationKey;
	@ApiModelProperty(value = "状态")
	private String status;
	@ApiModelProperty(value = "平台账号")
	private String accountName;
	@ApiModelProperty(value = "ids")
	private Set<Long> ids;
	@ApiModelProperty(value = "模糊搜索")
	private String search;
	@ApiModelProperty(value = "计算考勤开始时间")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date clockStartDate;
	@ApiModelProperty(value = "计算考勤结束时间")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date clockEndDate;
	@ApiModelProperty(value = "身份证号")
	private String idnumber;
	@ApiModelProperty(value = "上岗")
	private Boolean isOnDuty;
	@ApiModelProperty(value = "二维码颜色")
	private Integer color;
	@ApiModelProperty(value = "是否是江西电建人员")
	private Boolean isJxdj;
	@ApiModelProperty(value = "是否通过项目查人")
	private Boolean byPerson;
	@ApiModelProperty(value = "公司类型")
	private Long typeKey;
	@ApiModelProperty(value = "不通过orgCode")
	private Boolean noneOrgCode;
	@ApiModelProperty(value = "角色id")
	private Long roleId;
}
