package com.yeejoin.amos.supervision.business.util;

import java.util.HashMap;
import java.util.List;

import com.yeejoin.amos.supervision.business.param.CheckStatsListPageParam;
import com.yeejoin.amos.supervision.core.common.request.CommonPageable;
import com.yeejoin.amos.supervision.core.common.request.CommonRequest;

public class CheckStatsParamUtils {

	public static CheckStatsListPageParam fillCheckInfoParam(List<CommonRequest> queryRequests,
                                                             CommonPageable commonPageable, HashMap<String, Object> perMap) {
		CheckStatsListPageParam param = new CheckStatsListPageParam();
		for (int i = 0; i < queryRequests.size(); i++) {
			String name = queryRequests.get(i).getName();
			if ("beginDate".equals(name)) {
				param.setBeginDate(toString(queryRequests.get(i).getValue()));
			} else if ("endDate".equals(name)) {
				param.setEndDate(toString(queryRequests.get(i).getValue()));
			} else if ("userName".equals(name)) {
				param.setRouteId(toString(queryRequests.get(i).getValue()));
			} else if ("pointNo".equals(name)) {
				param.setPointNo(toString(queryRequests.get(i).getValue()));
			} else if ("pointName".equals(name)) {
				param.setPointName(toString(queryRequests.get(i).getValue()));
			} else if ("isFixed".equals(name)) {
				param.setIsFixed(toString(queryRequests.get(i).getValue()));
			} else if ("finishStatus".equals(name)) {
				param.setFinishStatus(toString(queryRequests.get(i).getValue()));
			} else if ("isOK".equals(name)) {
				param.setIsOK(toString(queryRequests.get(i).getValue()));
			} else if ("planId".equals(name)) {
				param.setPlanId(toString(queryRequests.get(i).getValue()));
			} else if ("routeId".equals(name)) {
				param.setRouteId(toString(queryRequests.get(i).getValue()));
			} else if ("catalogId".equals(name)) {
				param.setCatalogId(toString(queryRequests.get(i).getValue()));
			} else if ("caliderName".equals(name)) {
				param.setCaliberName(toString(queryRequests.get(i).getValue()));
			}
		}
		param.setOrgCode(perMap.get("orgCode") == null ? null : perMap.get("orgCode").toString());
		param.setUserId(perMap.get("userId") == null ? null : perMap.get("userId").toString());
		if (commonPageable != null) {
			param.setPageNumber(commonPageable.getPageNumber());
			param.setPageSize(commonPageable.getPageSize());
		}
		return param;
	}
	
	private static String toString(Object value) {
		if (null == value || value == "") {
			return null;
		} else {
			return value.toString();
		}
	}
}
