package com.yeejoin.amos.boot.module.jyjc.biz.feign;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jyjc.biz.config.XidFeignConfiguration;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.workflow.model.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

@FeignClient(contextId = "jyjc", name = "${workflow.feign.name:AMOS-API-WORKFLOW}", path = "workflow", configuration = {XidFeignConfiguration.class})
public interface WorkflowFeignClient {

    /***
     * 根据task_id 获取节点信息
     *
     * */
    @RequestMapping(value = "/history/task/nodeInfo", method = RequestMethod.GET)
    FeignClientResult<JSONObject> getNodeInfo(@RequestParam(value = "taskId") String taskId);


    /***
     *
     * 查询当前流程对应的可执行任务，无权限级别
     * */

    @RequestMapping(value = "/task/getTaskNoAuth/{processInstanceId}", method = RequestMethod.GET)
    JSONObject getTaskNoAuth(@PathVariable(value = "processInstanceId") String processInstanceId);

    /***
     *
     * 获取流程审批日志
     * */
    @RequestMapping(value = "/task/flowLogger/{procInsId}", method = RequestMethod.GET)
    FeignClientResult<Map<String,Object>> getFlowLogger(@PathVariable(value = "procInsId") String procInsId);



    @RequestMapping(value = "/history/task/nodeInfo", method = RequestMethod.GET)
    FeignClientResult<JSONObject> getNodeInfotoken(
            @RequestHeader(name="appKey",required = true) String appKey,
            @RequestHeader(name="product",required = true) String product,
            @RequestHeader(name="token",required = true) String token,
            @RequestParam(value = "taskId") String taskId);


    /***
     *
     * 查询当前流程对应的可执行任务，无权限级别
     * */

    @RequestMapping(value = "/task/getTaskNoAuth/{processInstanceId}", method = RequestMethod.GET)
    JSONObject getTaskNoAuthtoken(
            @RequestHeader(name="appKey",required = true) String appKey,
            @RequestHeader(name="product",required = true) String product,
            @RequestHeader(name="token",required = true) String token,
            @PathVariable(value = "processInstanceId") String processInstanceId);

    @RequestMapping(value = "/v2/task/rollBack/{processInstanceId}", method = RequestMethod.POST)
    JSONObject rollBack(@PathVariable(value = "processInstanceId") String processInstanceId);

    /**
     * 工作流启动接口
     *
     * @param params 业务参数
     * @return ProcessTaskDTO
     * @throws Exception e
     */
    @RequestMapping(value = "/v2/task/start/batch", method = RequestMethod.POST)
    FeignClientResult<List<ProcessTaskDTO>> startForBatch(@RequestBody ActWorkflowBatchDTO params) throws Exception;

    /**
     * 工作流驳回任务接口
     *
     * @param taskId 任务Id
     * @param data   业务参数
     * @return ProcessTaskDTO
     * @throws Exception e
     */
    @RequestMapping(value = "/v2/task/reject/{taskId}", method = RequestMethod.POST)
    FeignClientResult<ProcessTaskDTO> reject(@PathVariable("taskId") String taskId, @RequestBody TaskResultDTO data) throws Exception;


    /**
     * 任务驳回到指定节点
     *
     * @param taskId 任务Id
     * @param data   业务参数
     * @return ProcessTaskDTO
     * @throws Exception e
     */
    @RequestMapping(value = "/v2/task/reject/specifiedNode/{taskId}", method = RequestMethod.POST)
    FeignClientResult<ProcessTaskDTO> specifiedNode(@PathVariable("taskId") String taskId, @RequestBody TaskResultDTO data);

    /**
     * 工作流完成任务接口
     *
     * @param taskId 任务Id
     * @param data   业务参数
     * @return ProcessTaskDTO
     * @throws Exception e
     */
    @RequestMapping(value = "/v2/task/complete/standard/{taskId}", method = RequestMethod.POST)
    FeignClientResult<ProcessTaskDTO> completeByTaskFroStandard(@PathVariable("taskId") String taskId, @RequestBody TaskResultDTO data) throws Exception;

    /**
     * 工作流撤回
     *
     * @param processInstanceId processInstanceId
     * @return ProcessTaskDTO
     */
    @PostMapping(value = "/v2/task/rollBack/standard/{processInstanceId}")
    FeignClientResult<ProcessTaskDTO> rollBackTask(@PathVariable("processInstanceId") String processInstanceId);

    /**
     * 转办任务
     *
     * @param flowTaskVo flowTaskVo
     * @return ProcessTaskDTO
     */
    @PostMapping(value = "/v2/task/assign")
    FeignClientResult<ProcessTaskDTO> assign(@RequestBody FlowTaskVo flowTaskVo);

    /**
     * 终止流程
     *
     * @param processInstanceId processInstanceId
     * @return ProcessInstanceDTO
     * @throws Exception e
     */
    @DeleteMapping(value = "/v2/task/stopProcess/{processInstanceId}")
    FeignClientResult<ProcessInstanceDTO> stopProcess(@PathVariable("processInstanceId") String processInstanceId, @RequestParam(required = false, value = "stopReason") String stopReason) throws Exception;

    /**
     * 处理审批错误历史数据
     *
     * @param processInstanceId processInstanceId
     * @return ProcessTaskDTO
     */
    @RequestMapping(value = "/v2/task/error/history/data/{processInstanceId}", method = RequestMethod.GET)
    FeignClientResult<ProcessTaskDTO> handleErrorForm(@PathVariable("processInstanceId") String processInstanceId,
                                                      @RequestParam(value = "receiveCompanyCode") String receiveCompanyCode);
}

