package com.yeejoin.amos.boot.module.ugp.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
@AllArgsConstructor
public enum ProjectInitiationEnum {
    项目立项("1","项目立项","XMLX","被驳回，请重新申请","",""),
    平台审核("2","平台审核","PTSH","项目待平台审核","审核项目","待审核"),
    告知申请("3","告知申请","GZSQ","告知待申请","告知申请","待申请"),
    接受告知("4","接受告知","JSGZ","告知待接收","告知接收","待接收"),
    审查项目("5","审查项目","SCXM","告知待审查","项目告知审查","待审查"),
    提交资料("6","提交资料","TJZL","项目资料待提交","项目资料提交","待提交"),
    审批人审批("7","审批人审批","SPRSP","项目资料待审批","项目资料审批","待审批"),
    审核人审核("8","审核人审核","SHRSH","项目资料待审核","项目资料审核","待审核"),
    监检科室分配("9","监检科室分配","JJKSFP","监检科室待分配","监检科室分配","待分配"),
    监检员分配("10","监检员分配","JJYFP","监检员待分配","监检员分配","待分配"),
    监检员审核("11","监检员审核","JJYSH","监检员待审核","监检员审核","待审核"),
    项目关闭("12","项目关闭","XMGB","","",""),
    接受审查意见("13","接受审查意见","JSSCYJ","审查意见待接受","接受审查意见","待接受"),
    流程结束("14","流程结束！","LCJS","","","");

    private String status;
    private String name;
    private String code;
    private String taskDetailStatus;
    private String taskName;
    private String taskStatus;

    public static Map<String,String> getNameByStatusMap = new HashMap<String,String>();
    public static Map<String,String> getStatusByNameMap = new HashMap<String,String>();
    public static Map<String,String> getCodeByNameMap = new HashMap<String,String>();
    public static Map<String,String> getTaskStatusMap = new HashMap<String, String>();
    public static Map<String,String> getTaskNameMap = new HashMap<String, String>();
    public static Map<String, String> getTaskDetailStatusMap = new HashMap<String, String>();

    static {
        for(ProjectInitiationEnum projectInitiationEnum:ProjectInitiationEnum.values()){
            getNameByStatusMap.put(projectInitiationEnum.status,projectInitiationEnum.name);
            getStatusByNameMap.put(projectInitiationEnum.name, projectInitiationEnum.status);
            getCodeByNameMap.put(projectInitiationEnum.name,projectInitiationEnum.code);
            getTaskStatusMap.put(projectInitiationEnum.name,projectInitiationEnum.taskStatus);
            getTaskNameMap.put(projectInitiationEnum.name,projectInitiationEnum.taskName);
            getTaskDetailStatusMap.put(projectInitiationEnum.name,projectInitiationEnum.taskDetailStatus);
        }
    }

}
