package com.yeejoin.amos.boot.module.ugp.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 焊口信息表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="WeldDto", description="焊口信息表")
public class WeldDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "焊口编码")
    private String code;

    @ApiModelProperty(value = "项目id")
    private Long projectId;
    @ApiModelProperty(value = "项目名称")
    private String name;

    @ApiModelProperty(value = "安装企业")
    private Long installCompany;
    @ApiModelProperty(value = "安装单位")
    private String 	installationUnit;

    @ApiModelProperty(value = "所在地")
    private String region;

    @ApiModelProperty(value = "赋码状态(0未赋码，1赋码成功)")
    private String codingStatus;

    @ApiModelProperty(value = "赋码方式")
    private String codingMethod;

    @ApiModelProperty(value = "监检状态")
    private String superInspecStatus;

    @ApiModelProperty(value = "赋码日期")
    private Date codingDate;

    @ApiModelProperty(value = "监察单位")
    private String superviseDept;

    @ApiModelProperty(value = "检验检测单位")
    private String insDep;

    @ApiModelProperty(value = "检验检测单位负责人")
    private String insPerson;

    @ApiModelProperty(value = "经度")
    private String longitude;

    @ApiModelProperty(value = "纬度")
    private String latitude;

    @ApiModelProperty(value = "焊口状态(0-进行中，1-已完成)")
    private Integer status;

}
