package com.yeejoin.amos.boot.module.ugp.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
/**
 * 监检任务表
 *
 * @author duanwei
 * @date 2022-10-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value="TzUgpTask对象", description="监检任务表")
@TableName("tz_ugp_task")
public class Task extends BaseEntity {

    private static final long serialVersionUID = 1L;





    @ApiModelProperty(value = "任务名称")
    private String title;


    @ApiModelProperty(value = "项目id")
    private Long sourceId;

    @ApiModelProperty(value = "任务状态（0：未开始 1：进行中 2：已结束）")
    private Boolean status;

    @ApiModelProperty(value = "任务开始时间")
    private String statusLabel;

    private String taskType;

    private String taskTypeLabel;
    private String content;
    private String agencyCode;
    private Date sendTime;

    private String type;
    private Long unitId;
    @TableField(exist = false)
    private String extend; //url路径







}
