package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.ugp.api.Enum.*;
import com.yeejoin.amos.boot.module.ugp.api.dto.TaskDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.*;
import com.yeejoin.amos.boot.module.ugp.api.mapper.TaskMapper;
import com.yeejoin.amos.boot.module.ugp.api.mapper.TzUgpPathMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.TaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.*;

/**
 * 监检任务表 服务实现类
 *
 * @author duanwei
 * @date 2022-10-19
 */
@Service
public class TaskServiceImpl extends BaseService<TaskDto, Task, TaskMapper> implements TaskService {

    @Autowired
    OrgServiceImpl orgService;

    @Autowired
    ProjectResourceServiceImpl projectResourceService;

    @Autowired
    QualityProblemServiceImpl qualityProblemService;

    @Autowired
    SuperviseRuleServiceImpl superviseRuleService;

    @Autowired
    CompanyServiceImpl companyService;

    @Autowired
    ProjectInitiationServiceImpl projectInitiationService;

    @Autowired
    TzUgpPathMapper tzUgpPathMapper;

    /**
     * 项目流程新增、更新任务表信息
     * @param InitiationStatus 项目/问题处置 表中的 status字段
     * @param taskType 任务类型（填报、流程）
     * @param sendTime
     * @Param sequenceNbr 项目/问题处置的sequenceNbr
     * @return
     */
    public void saveOrUpdateTask(String InitiationStatus, boolean status, String taskType, Date sendTime, Long sourceId, String type, List<Long> unitIds) {
        if (!ValidationUtil.isEmpty(unitIds)) {
            for (Long unitId : unitIds) {
                Task task = new Task();
                String title = "", taskStatus = "";
                task.setTaskType(taskType);
                if (!ValidationUtil.isEmpty(InitiationStatus)) {
                    title = ProjectInitiationEnum.getTaskNameMap.get(InitiationStatus);
                    taskStatus = ProjectInitiationEnum.getTaskStatusMap.get(InitiationStatus);
                    if (ValidationUtil.isEmpty(title)) {
                        //不是项目立项流程，是问题处置流程
                        title = ProblemProcessEnum.getTaskNameMap.get(InitiationStatus);
                        taskStatus = ProblemProcessEnum.getTaskStatusMap.get(InitiationStatus);
                    }
                }

                if (ValidationUtil.isEmpty(title)) {
                    //不是问题处置流程，企业注册任务
                    title = CompanyExamineEnum.企业审核.getName();
                    if (status) {
                        taskStatus = CompanyExamineEnum.企业审核.getYes();
                    } else {
                        taskStatus = CompanyExamineEnum.企业审核.getNo();
                    }
                }

                if (TaskTypeEnum.填报.getKey().equals(taskType)) {
                    task.setTaskTypeLabel(TaskTypeEnum.填报.getName());
                } else if (TaskTypeEnum.流程.getKey().equals(taskType)) {
                    task.setTaskTypeLabel(TaskTypeEnum.流程.getName());
                } else {
                    task.setTaskTypeLabel(TaskTypeEnum.企业审核.getName());
                }

                task.setUnitId(unitId);
                task.setTitle(title);
                task.setStatus(status);
                task.setSendTime(sendTime);
                task.setSourceId(sourceId);
                task.setType(type);

                if (status) {
                    //更新任务表 已办
                    LambdaQueryWrapper<Task> wrapper = new LambdaQueryWrapper<>();
                    wrapper.eq(Task::getType, type)
                            .eq(Task::getStatus, false)
                            .eq(Task::getTitle, InitiationStatus)
                            .eq(Task::getSourceId, sourceId)
                            .eq(Task::getUnitId, unitId);
                    task = this.getOne(wrapper);
                    if (ValidationUtil.isEmpty(task)) {
                        return;
                    }
                    task.setStatusLabel(TaskTypeEnum.已办.getName());
                    taskStatus = "已完成";
                } else {
                    //添加任务表 待办
                    task.setStatusLabel(TaskTypeEnum.待办.getName());
                }
                task.setContent(title + ", " + taskStatus);

                this.saveOrUpdate(task);
            }
        }
    }
}
