package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.strategy;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jg.api.dto.FieldChangeMeta;
import com.yeejoin.amos.boot.module.jg.api.dto.PipelineChangeItemDto;
import com.yeejoin.amos.boot.module.jg.biz.controller.BizDataChangeController;

import java.util.List;
import java.util.Map;
import java.util.Set;

public interface IBizDataChangeHandleStrategy {

    /**
     * 可处理的业务类型(使用登记等)
     *
     * @return 业务类型
     */
    String canHandleBizType();
    /**

     * 获取变更信息详情-二级详情
     *
     * @param applyNo 单据或者设备唯一，单据编辑时用来查询eq表
     * @param bizId   设备record或者装置id
     * @param type    编辑的资源的类型：设备、装置
     * @return 变更信息详情
     */
    Map<String, Object> getSubDetail(String applyNo, String bizId, BizDataChangeController.DetailType type);

    /**
     * 获取变更信息详情-一级详情
     *
     * @param applyNo      单据编号
     * @param type         编辑的资源的类型：设备、装置
     * @param searchParams 查询参数
     * @return 变更信息详情
     */
    IPage<?> getDetail(String applyNo, BizDataChangeController.DetailType type, JSONObject searchParams);

    /**
     * 保存
     *
     * @param bizId                 设备record或者装置id
     * @param applyNo               单据编号
     * @param model                 @see ModelType
     * @param changeData            变更数据
     * @param allChangeColumns      变化的字段
     * @param pipelineChangeItemMap 变化的管道信息汇总
     */
    List<FieldChangeMeta> postSave(String bizId, String applyNo, ModelType model, Map<String, Object> changeData, List<FieldChangeMeta> allChangeColumns, Map<String, List<PipelineChangeItemDto>> pipelineChangeItemMap);


    /**
     * 前置校验 如业务字段的重复性检验
     *
     * @param bizId      设备record或者装置id
     * @param applyNo    单据编号
     * @param model      类型
     * @param changeData 数据
     * @return 是否通过前置校验
     */
    Boolean beforeCheck(String bizId, String applyNo, ModelType model, Map<String, Object> changeData);

    /**
     * 单据方式：单个处理、批量处理
     */
    enum ModelType {
        singleProject,
        singleEquip
    }

    void doSave(String bizId, String applyNo, ModelType model, Map<String, Object> changeData, ReginParams selectedOrgInfo);

    /**
     * 获取子表的设备或者使用登记证
     *
     * @param applyNo 单据编号
     * @return 设备record或者证数组
     */
    Set<String> getEqs(String applyNo);

    /**
     * 单据是否已经审核完成
     *
     * @param applyNo 单据编号
     * @return true-完成；false-未完成
     */
    Boolean bizIsFinished(String applyNo);


    /**
     * 获取变更的装置ids
     *
     * @param applyNo 单据编号
     * @return 装置id集合
     */
    Set<String> getProjectContraptionIds(String applyNo);

    /**
     * 查询变更日志
     *
     * @param bizId 业务id
     * @return 分页数据
     */
    IPage<?> getChangeLogs(String bizId, int current, int size);
}
