package com.yeejoin.amos.boot.module.jg.biz.handler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jg.api.enums.SafetyProblemTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.event.SafetyProblemEvent;
import com.yeejoin.amos.boot.module.jg.api.event.handler.SafetyProblemEventHandler;
import com.yeejoin.amos.boot.module.jg.biz.handler.strategy.ProblemHandleStrategy;
import org.springframework.stereotype.Component;

/**
 * SJNXDJEventHandler 类实现了 SafetyProblemEventHandler 接口，
 * 用于处理超设计使用年限登记后问题闭环。
 */
@Component
public class SJNXDJEventHandler implements SafetyProblemEventHandler {

    private final ProblemHandleStrategy equipmentStrategy;

    public SJNXDJEventHandler(ProblemHandleStrategy equipmentStrategy) {
        this.equipmentStrategy = equipmentStrategy;
    }

    /**
     * 处理安全问题事件。
     *
     * @param event 安全问题事件对象，包含事件的详细信息。
     *              该参数用于描述发生的安全问题事件。
     */
    @Override
    public void handle(SafetyProblemEvent event) {
        // 此处为处理安全问题事件的逻辑代码
        JSONArray jsonArray = JSONObject.parseArray(event.getMessage().toString());
        equipmentStrategy.handleProblem(jsonArray, SafetyProblemTypeEnum.SJNXDJ);
    }
}

