package com.yeejoin.amos.boot.module.jg.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.JgScrapCancelDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgScrapCancel;
import com.yeejoin.amos.boot.module.jg.api.vo.SortVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 设备报废注销 Mapper 接口
 *
 * @author system_generator
 * @date 2023-12-20
 */
public interface JgScrapCancelMapper extends BaseMapper<JgScrapCancel> {

    Page<Map<String, Object>> getListPage(@Param("page") Page<Map<String, Object>> page,
                                          @Param("sort") SortVo sortMap,
                                          @Param("dto") JgScrapCancelDto dto,
                                          @Param("roleIds") List<String> roleIds,
                                          @Param("orgCode") String orgCode,
                                          @Param("currentUserId") String currentUserId
    );

    Map<String, Object> getDetail(@Param("id") String id);

    Map<String, Object> getInspectDetail(@Param("id") String id);

    Map<String, Object> getUseDetail(@Param("id") String id);

    Page<Map<String, Object>> getEquipListPage(@Param("page") Page<Map<String, Object>> page, @Param("factoryNum") String factoryNum, @Param("equList") String equList, @Param("equCategory") String equCategory);

    void updatePromoter(@Param("id") Long id);

    /**
     * 根据安装告知编号查询设备、设计、制造等信息
     *
     * @param sequenceNbr 安装告知编号
     */
    Map<String, Object> queryEquipInformation(@Param("sequenceNbr") long sequenceNbr);

}
