package com.yeejoin.amos.boot.module.jyjc.biz.event.listener;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Sequence;
import com.yeejoin.amos.boot.biz.common.entity.TzsBaseEntity;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplicationEquip;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplicationPushLog;
import com.yeejoin.amos.boot.module.jyjc.api.enums.EquipCategoryEnum;
import com.yeejoin.amos.boot.module.jyjc.api.model.InspectionApplicationPushData;
import com.yeejoin.amos.boot.module.jyjc.api.model.InspectionEquipData;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionApplicationModel;
import com.yeejoin.amos.boot.module.jyjc.biz.event.InspectionApplicationPushEvent;
import com.yeejoin.amos.boot.module.jyjc.biz.kafka.KafkaProducer;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.JyjcInspectionApplicationEquipServiceImpl;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.JyjcInspectionApplicationPushLogServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgConstructionInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgUseInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzBaseEnterpriseInfo;
import com.yeejoin.amos.boot.module.ymt.api.mapper.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;

/**
 * @author Administrator
 */
@Component
@Slf4j
public class InspectionApplicationPushEventListener implements ApplicationListener<InspectionApplicationPushEvent> {

    private BlockingQueue<JyjcInspectionApplicationModel> queue = new LinkedBlockingQueue<>();

    @Value("${inspection.push.max.deal.thread.num:2}")
    private int threadNum;

    @Autowired
    JyjcInspectionApplicationPushLogServiceImpl pushLogService;

    @Autowired
    JyjcInspectionApplicationEquipServiceImpl applicationEquipService;

    @Autowired
    IdxBizJgConstructionInfoMapper constructionInfoMapper;

    @Autowired
    IdxBizJgUseInfoMapper useInfoMapper;

    @Autowired
    TzBaseEnterpriseInfoMapper baseEnterpriseInfoMapper;

    @Autowired
    private EquipTechParamBoilerMapper equipTechParamBoilerMapper;

    @Autowired
    private EquipTechParamVesselMapper equipTechParamVesselMapper;

    @Autowired
    private EquipTechParamElevatorMapper equipTechParamElevatorMapper;

    @Autowired
    private EquipTechParamLiftingMapper equipTechParamLiftingMapper;

    @Autowired
    private EquipTechParamVehicleMapper equipTechParamVehicleMapper;

    @Autowired
    private EquipTechParamRidesMapper equipTechParamRidesMapper;

    @Autowired
    private EquipTechParamPipelineMapper equipTechParamPipelineMapper;

    @Autowired
    private EquipTechParamRopewayMapper equipTechParamRopewayMapper;

    @Autowired
    KafkaProducer kafkaProducer;

    @Autowired
    Sequence sequence;

    /**
     * 报检推送主题， 第一位为接收单位标识
     */
    private final String INSPECTION_APPLICATION_PUSH_TOPIC = "%s_INSPECTION_APPLICATION_TOPIC";


    @Override
    public void onApplicationEvent(InspectionApplicationPushEvent event) {
        log.info("收到报检推送请求：{}", event);
        queue.add(event.getJyjcInspectionApplicationModel());
    }

    @PostConstruct
    public void init() {
        ExecutorService executorService = Executors.newFixedThreadPool(threadNum);
        for (int i = 0; i < threadNum; i++) {
            executorService.execute(() -> {
                while (true) {
                    try {
                        JyjcInspectionApplicationModel applicationModel = queue.take();
                        //构建数据
                        JyjcInspectionApplicationPushLog pushLog = this.createPushData(applicationModel);
                        // 发送数据
                        this.pushData2Kafka(applicationModel.getDockingUnitCode(), pushLog);
                    } catch (Exception e) {
                        log.error(e.getMessage(), e);
                    }
                }
            });
        }
    }

    private void pushData2Kafka(String dockingUnitCode, JyjcInspectionApplicationPushLog pushLog) {
        // 发送kafka指定的主题
        String topic = String.format(INSPECTION_APPLICATION_PUSH_TOPIC, dockingUnitCode);
        kafkaProducer.sendMessage(topic, pushLog.getPushData());
        pushLog.setPushStatus("2");
        pushLogService.updateById(pushLog);
    }

    private JyjcInspectionApplicationPushLog createPushData(JyjcInspectionApplicationModel applicationModel) {
        long id = sequence.nextId();
        JyjcInspectionApplicationPushLog pushLog = new JyjcInspectionApplicationPushLog();
        pushLog.setInspectionUnitCode(applicationModel.getInspectionUnitCode());
        pushLog.setApplicationSeq(applicationModel.getSequenceNbr());
        // 初始状态
        pushLog.setSequenceNbr(id);
        pushLog.setPushStatus("1");
        pushLog.setPushData(this.buildData(id, applicationModel));
        pushLog.setRecDate(new Date());
        pushLogService.save(pushLog);
        return pushLog;
    }

    private String buildData(long traceId, JyjcInspectionApplicationModel applicationModel) {
        InspectionApplicationPushData pushData = new InspectionApplicationPushData();
        BeanUtil.copyProperties(applicationModel, pushData);
        // 监管机构
        pushData.setSuperviseOrgName(this.getSuperviseNameByCode(applicationModel.getApplicationUnitCode()));
        // 报检的设备信息
        pushData.setInspectionEquips(this.buildInspectionEquipInfo(applicationModel.getSequenceNbr()));
        pushData.setTraceId(traceId + "");
        return JSONObject.toJSONString(pushData);
    }

    private List<InspectionEquipData> buildInspectionEquipInfo(Long sequenceNbr) {
        List<JyjcInspectionApplicationEquip> jyjcInspectionApplicationEquips = applicationEquipService.list(new LambdaQueryWrapper<JyjcInspectionApplicationEquip>().eq(JyjcInspectionApplicationEquip::getApplicationSeq, sequenceNbr));
        return jyjcInspectionApplicationEquips.stream().map(e -> {
            InspectionEquipData equipData = new InspectionEquipData();
            BeanUtil.copyProperties(e, equipData);
            equipData.setAddress(this.getAddressByRecord(e.getEquipUnicode()));
            // 单个查询执行，原因数据量较大 in 慢
            this.setUscUnitInfo(equipData, e.getEquipUnicode());
            // 单个查询执行，原因数据量较大 in 慢
            this.setTechParams(equipData, e.getEquipUnicode());
            return equipData;
        }).collect(Collectors.toList());
    }

    private void setTechParams(InspectionEquipData equipData, String equipUnicode) {
        // 按照设备类型查询不同的技术参数表
        equipData.setTechParams(this.populateEquipInfoWithTechParams(equipData.getEquList(), equipUnicode));
    }

    private Map<String, Object> populateEquipInfoWithTechParams(String equList, String record) {
        EquipCategoryEnum productType = EquipCategoryEnum.of(Integer.parseInt(equList));
        switch (Objects.requireNonNull(productType)) {
            // 锅炉 - 暂时之前的 需求未出
            case IDX_BIZ_JG_TECH_PARAMS_BOILER:
                return BeanUtil.beanToMap(equipTechParamBoilerMapper.queryTechParamInUse(record));
            // 压力容器 - 暂时之前的 需求未出
            case IDX_BIZ_JG_TECH_PARAMS_VESSEL:
                return BeanUtil.beanToMap(equipTechParamVesselMapper.queryTechParamInUse(record));
            // 电梯
            case IDX_BIZ_JG_TECH_PARAMS_ELEVATOR:
                return BeanUtil.beanToMap(equipTechParamElevatorMapper.queryTechParamInUse(record));
            // 起重机械
            case IDX_BIZ_JG_TECH_PARAMS_LIFTING:
                return BeanUtil.beanToMap(equipTechParamLiftingMapper.queryTechParamInUse(record));
            // 场（厂）内专用机动车辆
            case IDX_BIZ_JG_TECH_PARAMS_VEHICLE:
                return BeanUtil.beanToMap(equipTechParamVehicleMapper.queryTechParamInUse(record));
            // 大型游乐设施
            case IDX_BIZ_JG_TECH_PARAMS_RIDES:
                return BeanUtil.beanToMap(equipTechParamRidesMapper.queryTechParamInUse(record));
            // 压力管道 - 暂时之前的 需求未出
            case IDX_BIZ_JG_TECH_PARAMS_PIPELINE:
                return BeanUtil.beanToMap(equipTechParamPipelineMapper.queryTechParamInUse(record));
            // 客运索道
            case IDX_BIZ_JG_TECH_PARAMS_ROPEWAY:
                return BeanUtil.beanToMap(equipTechParamRopewayMapper.queryTechParamInUse(record));
            default:
                break;
        }
        return null;
    }

    private String getAddressByRecord(String equipUnicode) {
        IdxBizJgUseInfo idxBizJgUseInfo = useInfoMapper.selectOne(new LambdaQueryWrapper<IdxBizJgUseInfo>().eq(IdxBizJgUseInfo::getRecord, equipUnicode));
        return null2Blank(idxBizJgUseInfo.getProvinceName()) + null2Blank(idxBizJgUseInfo.getCityName()) + null2Blank(idxBizJgUseInfo.getCountyName()) + null2Blank(idxBizJgUseInfo.getAddress());
    }

    private String null2Blank(String str) {
        return StrUtil.isNotEmpty(str) ? str : "";
    }

    private void setUscUnitInfo(InspectionEquipData equipData, String equipUnicode) {
        LambdaQueryWrapper<IdxBizJgConstructionInfo> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(IdxBizJgConstructionInfo::getRecord, equipUnicode);
        wrapper.orderByDesc(TzsBaseEntity::getRecDate);
        wrapper.last("limit 1");
        IdxBizJgConstructionInfo jgConstructionInfo = constructionInfoMapper.selectOne(wrapper);
        if (jgConstructionInfo != null) {
            equipData.setUscUnitCreditCode(jgConstructionInfo.getUscUnitCreditCode());
            equipData.setUscUnitCreditName(jgConstructionInfo.getUscUnitName());
        }
    }

    private String getSuperviseNameByCode(String applicationUnitCode) {
        //查询监管单位名称
        TzBaseEnterpriseInfo tzBaseEnterpriseInfo = baseEnterpriseInfoMapper.selectOne(new LambdaQueryWrapper<TzBaseEnterpriseInfo>().eq(TzBaseEnterpriseInfo::getUseCode, applicationUnitCode));
        return tzBaseEnterpriseInfo.getSuperviseOrgName();
    }


}
