package com.yeejoin.amos.boot.module.ymt.biz.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.excel.ExcelUtil;
import com.yeejoin.amos.boot.biz.common.utils.Menu;
import com.yeejoin.amos.boot.biz.common.utils.TreeParser;
import com.yeejoin.amos.boot.module.ymt.api.dto.EquipExportDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.EquipmentCategoryDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.EquipmentMessageDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.EquipmentCategory;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgConstructionInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgInspectionDetectionInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgMaintenanceRecordInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgOtherInfo;
import com.yeejoin.amos.boot.module.ymt.api.enums.ImageSizeEnums;
import com.yeejoin.amos.boot.module.ymt.api.mapper.EquipmentCategoryMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgOtherInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.service.IEquipmentCategoryService;
import com.yeejoin.amos.boot.module.ymt.api.vo.EquipExportVo;
import com.yeejoin.amos.boot.module.ymt.biz.config.FileDownLoadException;
import com.yeejoin.amos.boot.module.ymt.biz.service.impl.EquipmentCategoryServiceImpl;
import com.yeejoin.amos.boot.module.ymt.biz.utils.ImageUtils;
import com.yeejoin.amos.component.robot.BadRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 装备分类
 *
 * @author system_generator
 * @date 2021-10-20
 */
@RestController
@Api(tags = "装备分类Api")
@RequestMapping(value = "/equipment-category")
public class EquipmentCategoryController extends BaseController {

	@Autowired
	EquipmentCategoryServiceImpl equipmentCategoryServiceImpl;

	@Autowired
	IEquipmentCategoryService equipmentCategoryService;
	@Autowired
	EquipmentCategoryMapper equipmentCategoryMapper;


	@Value("${regulatory_code_prefix}")
	String REGULATORY_CODE_PREFIX ;


	@Autowired
	IdxBizJgOtherInfoMapper idxBizJgOtherInfoMapper;

	/**
	 * 新增装备分类
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增装备分类", notes = "新增装备分类")
	public ResponseModel<EquipmentCategoryDto> save(@RequestBody EquipmentCategoryDto model) {
		model = equipmentCategoryServiceImpl.createWithModel(model);
		return ResponseHelper.buildResponse(model);
	}

	/**
	 * 根据sequenceNbr删除
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@DeleteMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除装备分类", notes = "根据sequenceNbr删除装备分类")
	public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request,
													  @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		return ResponseHelper.buildResponse(equipmentCategoryServiceImpl.removeById(sequenceNbr));
	}

	/**
	 * 根据sequenceNbr查询
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个装备分类", notes = "根据sequenceNbr查询单个装备分类")
	public ResponseModel<EquipmentCategoryDto> selectOne(@PathVariable Long sequenceNbr) {
		return ResponseHelper.buildResponse(equipmentCategoryServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
	 * 列表分页查询
	 *
	 * @param current 当前页
	 * @param current 每页大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET", value = "装备分类分页查询", notes = "装备分类分页查询")
	public ResponseModel<Page<EquipmentCategoryDto>> queryForPage(@RequestParam(value = "current") int current,
																  @RequestParam(value = "size") int size) {
		Page<EquipmentCategoryDto> page = new Page<EquipmentCategoryDto>();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(equipmentCategoryServiceImpl.queryForEquipmentCategoryPage(page));
	}

	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "装备分类列表全部数据查询", notes = "装备分类列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<EquipmentCategoryDto>> selectForList() {
		return ResponseHelper.buildResponse(equipmentCategoryServiceImpl.queryForEquipmentCategoryList());
	}

	/**
	 * 树
	 *
	 * @return
	 * @throws Exception
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "装备分类列表全部数据查询", notes = "装备分类列表全部数据查询")
	@GetMapping(value = "/tree")
	public ResponseModel<Object> tree(@RequestParam(value = "code",required = false) String code) throws Exception {
		if(ObjectUtils.isEmpty(code)){
			return ResponseHelper.buildResponse(new ArrayList<>());
		}
		EquipmentCategory root = equipmentCategoryServiceImpl.getOne(new LambdaQueryWrapper<EquipmentCategory>().eq(EquipmentCategory::getCode, code));
		QueryWrapper<EquipmentCategory> queryWrapper = new QueryWrapper<>();
		queryWrapper.likeRight("code", code.replaceAll("0+$", ""));
		Collection<EquipmentCategory> list = equipmentCategoryServiceImpl.list(queryWrapper);
		Menu menu = new Menu(root.getId(), root.getName(), 0L, 0);
		List<Menu> menus = TreeParser.getTree(root.getId(), list, EquipmentCategory.class.getName(), "getId", 0, "getName",
				"getParentId", null, "getCode");
		menu.setChildren(menus);
		List<Menu> tree = new ArrayList<>();
		tree.add(menu);
		return ResponseHelper.buildResponse(tree);
	}

	/**
	 * 返回设备品种树第一个节点
	 *
	 * @return
	 * @throws Exception
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "装备分类列表全部数据查询", notes = "装备分类列表全部数据查询")
	@GetMapping(value = "/firstNode")
	public ResponseModel<Object> firstNode(@RequestParam(value = "code",required = false) String code) throws Exception {
		if(ObjectUtils.isEmpty(code)){
			return ResponseHelper.buildResponse(new ArrayList<>());
		}
		EquipmentCategory root = equipmentCategoryServiceImpl.getOne(new LambdaQueryWrapper<EquipmentCategory>().eq(EquipmentCategory::getCode, code));
		QueryWrapper<EquipmentCategory> queryWrapper = new QueryWrapper<>();
		queryWrapper.likeRight("code", code.replaceAll("0+$", ""));
		Collection<EquipmentCategory> list = equipmentCategoryServiceImpl.list(queryWrapper);
		List<Menu> menus = TreeParser.getTree(root.getId(), list, EquipmentCategory.class.getName(), "getId", 0, "getName",
				"getParentId", null, "getCode");
		return ResponseHelper.buildResponse(menus.get(0));
	}

	/**
	 * 设备分类八大类
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "设备分类八大类", notes = "设备分类八大类")
	@GetMapping(value = "/selectClassify")
	public ResponseModel<JSONArray> selectClassify() {
		List<EquipmentCategoryDto> equipmentCategoryDtos = equipmentCategoryServiceImpl.selectClassify();
		JSONArray jsonArray = new JSONArray();
		equipmentCategoryDtos.forEach(e->{
					jsonArray.add(e.getName());
				}
		);
		return ResponseHelper.buildResponse(jsonArray);
	}

	/**
	 * 设备八大类列表树
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "设备八大类列表树", notes = "设备八大类列表树")
	@GetMapping(value = "/equipTree")
	public ResponseModel<Object> equipTree(@RequestParam(value = "type",required = false) String type) {
		return ResponseHelper.buildResponse( equipmentCategoryService.equipTree(type));
	}

	/**
	 * 设备认领总览
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "设备认领总览", notes = "设备认领总览")
	@GetMapping(value = "/equipClaimOverview")
	public ResponseModel<Object> equipClaimOverview() {
		return ResponseHelper.buildResponse(equipmentCategoryService.equipClaimOverview());
	}

	/**
	 * 生成监管码和96333码
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/createSupervisorCode", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "生成监管码和96333码", notes = "生成监管码和96333码")
	public ResponseModel<Object> createSupervisorCode(@RequestBody Map<String,Object> map) {
		return ResponseHelper.buildResponse(equipmentCategoryService.createSupervisorCode(map));
	}

	/**
	 * 修改数据状态是否显示编辑按钮
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/updateOtherInfo", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "修改数据状态", notes = "修改数据状态")
	public ResponseModel<Object> updateOtherInfo(@RequestBody Map<String,Object> map) {
		return ResponseHelper.buildResponse(equipmentCategoryService.updateOtherInfo(map));
	}

	/**
	 * 根据record查询表格数据详情
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@RequestMapping(value = "/getFormRecordById", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "表格查询详情", notes = "表格查询详情")
	public ResponseModel<Object> getFormRecordById(@RequestParam Map<String, Object> map) {
		return ResponseHelper.buildResponse(equipmentCategoryService.getFormRecordById(map));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/checkCode", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "校验使用登记证编号、设备代码、96333码重复", notes = "校验使用登记证编号、设备代码、96333码重复")
	public ResponseModel<Object> checkCode(@RequestBody Map<String,Object> obj){
		String message = equipmentCategoryService.checkCode(obj);
		if(ObjectUtils.isEmpty(message)){
			return ResponseHelper.buildResponse(true);
		} else {
			ResponseModel<Object> response = new ResponseModel();
			response.setResult(null);
			response.setMessage(message);
			response.setStatus(HttpStatus.BAD_REQUEST.value());
			return response;
		}

	}

	/**
	 * 一码通八大类设备数据操作接口
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/submit", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "一码通八大类设备数据操作接口", notes = "一码通八大类设备数据操作接口")
	public ResponseModel<Object> submit(@RequestBody Map<String, Object> map) {
		return ResponseHelper.buildResponse(equipmentCategoryService.submit(map));
	}


	/**
	 * 批量一码通删除数据
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/deleteBatch", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "批量删除一码通数据", notes = "批量删除一码通数据")
	public ResponseModel<Object> deleteBatch(@RequestBody Map<String,Object> map) {
		return ResponseHelper.buildResponse(equipmentCategoryService.deleteBatch(map));
	}


	/**
	 * 获取管辖分局树
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/creatTree")
	@ApiOperation(httpMethod = "GET", value = "获取管辖分局树", notes = "获取管辖分局树")
	public ResponseModel<Object> creatTree() {
		return ResponseHelper.buildResponse(equipmentCategoryService.getTree());
	}


	/**
	 * 重新生成西咸新区的码
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@GetMapping(value = "/creatXiXian")
	@ApiOperation(httpMethod = "GET", value = "西咸存量数据处理功能", notes = "西咸存量数据处理功能")
	public ResponseModel<Object> creatXiXian(@RequestParam String type) {
		equipmentCategoryService.creatXiXian(type);
		return ResponseHelper.buildResponse("ok");
	}



	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getTable")
	@ApiOperation(httpMethod = "GET", value = "设备认领和设备管理通用接口", notes = "设备认领和设备管理通用接口")
	public ResponseModel<Page<Map<String,Object>>> getTable(@RequestParam Map<String,Object> map) {
		return ResponseHelper.buildResponse(equipmentCategoryServiceImpl.getTable(map));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/exportData")
	@ApiOperation(httpMethod = "GET", value = "设备信息导出", notes = "设备信息导出")
	public void exportData(HttpServletResponse response, EquipExportDto dto) {
		if (!ObjectUtils.isEmpty(dto.getUSE_PLACE())) {
			String address = dto.getUSE_PLACE().substring(1, dto.getUSE_PLACE().length() - 1);
			address = address.replace(", ", "/");
			dto.setUSE_PLACE(address);
		}
		List<EquipExportVo> equipExportData = equipmentCategoryServiceImpl.getEquipExportData(dto);
		ExcelUtil.createTemplate(response, "设备信息", "设备信息", equipExportData, EquipExportVo.class, null, false);
	}



	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/scalp")
	@ApiOperation(httpMethod = "GET", value = "设备筛选下拉", notes = "设备筛选下拉")
	public ResponseModel<List<Map<String, Object>>> scalp(@RequestParam Map<String,Object> map) {
		return ResponseHelper.buildResponse(equipmentCategoryServiceImpl.scalp(map));
	}



	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getChildren")
	@ApiOperation(httpMethod = "GET", value = "通过设备种类code获取设备类别", notes = "通过设备种类code获取设备类别")
	public ResponseModel<List<EquipmentCategory>> getChildren(String code) {
		return ResponseHelper.buildResponse(equipmentCategoryServiceImpl.getChildren(code));
	}



	/**
	 * 获取行政区划
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "getRegion")
	@ApiOperation(httpMethod = "GET", value = "获取行政区划", notes = "获取行政区划")
	public ResponseModel<Object> getRegion(@RequestParam(value = "level", required = false) String level,
										   @RequestParam(value = "parentId", required = false) String parentId) {
		return ResponseHelper.buildResponse(equipmentCategoryService.getRegion(level,parentId));
	}


	/**
	 * 根据Record获取类别和品种
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getCategoryAndDefineByRecord")
	@ApiOperation(httpMethod = "GET", value = "根据Record获取类别和品种", notes = "根据Record获取类别和品种")
	public ResponseModel<Object> getCategoryAndDefineById(@RequestParam(value = "rowId", required = false) String rowId) {
		return ResponseHelper.buildResponse(equipmentCategoryService.getCategoryAndDefineByRecord(rowId));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@GetMapping(value = "saveEquipmentCategoryToEs")
	@ApiOperation(httpMethod = "GET", value = "一码通数据初始化至es", notes = "一码通数据初始化至es")
	public ResponseModel<String> saveEquipmentCategoryToEs() {
		equipmentCategoryServiceImpl.saveEs();
		return ResponseHelper.buildResponse("success");
	}



	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/viewJgAll")
	@ApiOperation(httpMethod = "GET", value = "viewJgAll", notes = "viewJgAll")
	public ResponseModel<Page<JSONObject>> viewJgAll( @RequestParam Map<String,Object> map) {
		JSONObject jsonObject = new JSONObject(map);
		return ResponseHelper.buildResponse(equipmentCategoryServiceImpl.queryByKeys(jsonObject));
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/checkRepeat")
	@ApiOperation(httpMethod = "GET", value = "校验码重复", notes = "校验码重复")
	public ResponseModel<Boolean> checkRepeat(@RequestParam(value = "code") String code,
											  @RequestParam(value = "elevatorCode", required = false) String elevatorCode) {

		return ResponseHelper.buildResponse(repeat(code, elevatorCode));
	}


	private Boolean repeat(String code, String elevatorCode){
		boolean flag = true;
		if (!ObjectUtils.isEmpty(code)) {
			LambdaQueryWrapper<IdxBizJgOtherInfo> lambda = new QueryWrapper<IdxBizJgOtherInfo>().lambda();
			lambda.eq(IdxBizJgOtherInfo::getClaimStatus, "已认领");
			lambda.eq(IdxBizJgOtherInfo::getSupervisoryCode, code);
			Integer integer = idxBizJgOtherInfoMapper.selectCount(lambda);
			if (integer > 1) {
				flag = false;
			}
		}
		if (!ObjectUtils.isEmpty(elevatorCode)) {
			LambdaQueryWrapper<IdxBizJgOtherInfo> lambda = new QueryWrapper<IdxBizJgOtherInfo>().lambda();
			lambda.eq(IdxBizJgOtherInfo::getClaimStatus, "已认领");
			lambda.eq(IdxBizJgOtherInfo::getCode96333, elevatorCode);
			Integer integer = idxBizJgOtherInfoMapper.selectCount(lambda);
			if (integer > 1) {
				flag = false;
			}
		}
		return flag;
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/exportImage")
	@ApiOperation(httpMethod = "GET", value = "设备监管码下载", notes = "设备监管码下载")
	public void exportImage(HttpServletResponse response, @RequestParam("code") String code, @RequestParam("type") String type, @RequestParam(value = "elevatorCode", required = false) String elevatorCode) throws IOException, FileNotFoundException {
		ImageSizeEnums imageSizeEnums = ImageSizeEnums.getEnumByCode(type);
		// 获取resources目录下的文件输入流
		InputStream bgImgFile = getClass().getClassLoader().getResourceAsStream("temp/" + imageSizeEnums.getBgPath());
		File QrCodeFile;
		boolean repeat = repeat(code, elevatorCode);
		if (!repeat) {
			throw new BadRequest("存在重复数据，请联系管理员！");
		}
		if (ImageSizeEnums.DT.getCode().equals(type)) {
			QrCodeFile = File.createTempFile(elevatorCode, ".png");
			ImageUtils.creatQRCode(QrCodeFile, bgImgFile, imageSizeEnums.getWith(), imageSizeEnums.getHeight(), REGULATORY_CODE_PREFIX + code, "", elevatorCode, imageSizeEnums.getSize(), imageSizeEnums.getImagesX(), imageSizeEnums.getImagesY(), imageSizeEnums.getText1X(), imageSizeEnums.getText1Y(), imageSizeEnums.getText2X(), imageSizeEnums.getText2Y());
			ImageUtils.downloadResource(elevatorCode + ".png", QrCodeFile.getAbsolutePath(), response);
		} else {
			QrCodeFile = File.createTempFile(code, ".png");
			ImageUtils.creatQRCode(QrCodeFile, bgImgFile, imageSizeEnums.getWith(), imageSizeEnums.getHeight(), REGULATORY_CODE_PREFIX + code, "", code, imageSizeEnums.getSize(), imageSizeEnums.getImagesX(), imageSizeEnums.getImagesY(), imageSizeEnums.getText1X(), imageSizeEnums.getText1Y(), imageSizeEnums.getText2X(), imageSizeEnums.getText2Y());
			ImageUtils.downloadResource(code + ".png", QrCodeFile.getAbsolutePath(), response);
		}
		QrCodeFile.delete();
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/exportImageZip")
	@ApiOperation(httpMethod = "GET", value = "设备监管码、电梯码批量导出压缩包", notes = "设备监管码、电梯码批量导出压缩包")
	public void exportImageZip(HttpServletResponse response, @RequestParam Map<String, Object> map) throws IOException {
		String type = String.valueOf(map.get("type"));
		ImageSizeEnums imageSizeEnums = ImageSizeEnums.getEnumByCode(type);
		//创建list 存放图片
		List<File> fileList = new ArrayList<>();
		JSONObject jsonObject = new JSONObject(map);
		Page<JSONObject> pageList = equipmentCategoryServiceImpl.queryByKeys(jsonObject);
		List<JSONObject> equipExportData;
		List<String> strings = null;
		if (map.containsKey("ids") && !ObjectUtils.isEmpty(map.get("ids"))) {
			strings  = Arrays.asList(String.valueOf(map.get("ids")).split(","));
			List<String> finalStrings = strings;
			equipExportData = pageList.getRecords().stream().filter(item -> finalStrings.contains(String.valueOf(item.get("SEQUENCE_NBR")))).collect(Collectors.toList());
		} else {
			equipExportData = pageList.getRecords();
		}

		if (ObjectUtils.isEmpty(equipExportData)) {
			File zipFile = File.createTempFile("设备码信息", ".zip");
			File nullFile = File.createTempFile("当前导出数据为空+", ".txt");
			fileList.add(nullFile);
			// 调用压缩方法
			ImageUtils.zipFiles(fileList, zipFile, ".txt");
			ImageUtils.downloadResourceZip("设备码信息.zip", zipFile.getAbsolutePath(), response);
			zipFile.delete();
		}
		List<Object> code96333 = equipExportData.stream().filter(item -> !ObjectUtils.isEmpty(item.get("CODE96333"))).map(item -> item.get("CODE96333")).collect(Collectors.toList());
		if (ObjectUtils.isEmpty(code96333) && ImageSizeEnums.DT.getCode().equals(type)){
			throw new FileDownLoadException("96333码为空！");
		}
		if (!ObjectUtils.isEmpty(code96333)) {
			LambdaQueryWrapper<IdxBizJgOtherInfo> lambda = new QueryWrapper<IdxBizJgOtherInfo>().lambda();
			lambda.eq(IdxBizJgOtherInfo::getClaimStatus, "已认领");
			lambda.in(IdxBizJgOtherInfo::getCode96333, code96333);
//			Integer integer = idxBizJgOtherInfoMapper.selectCount(lambda);
			List<IdxBizJgOtherInfo> idxBizJgOtherInfos = idxBizJgOtherInfoMapper.selectList(lambda);
			List<String> collect = idxBizJgOtherInfos.stream().map(IdxBizJgOtherInfo::getCode96333).collect(Collectors.toList());
			HashSet<String> strings1 = new HashSet<>(collect);
//			if (!ObjectUtils.isEmpty(strings) && strings.size() != strings1.size()){
//				throw new FileDownLoadException("96333码存在重复数据，请联系管理员！");
//			}
			if (code96333.size()!=strings1.size() || idxBizJgOtherInfos.size() != code96333.size()) {
				throw new FileDownLoadException("96333码存在重复数据，请联系管理员！");
			}
		}
		List<Object> supervisoryCode = equipExportData.stream().filter(item -> !ObjectUtils.isEmpty(item.get("SUPERVISORY_CODE"))).map(item -> item.get("SUPERVISORY_CODE")).collect(Collectors.toList());
		if (!ObjectUtils.isEmpty(supervisoryCode)) {
			LambdaQueryWrapper<IdxBizJgOtherInfo> lambda = new QueryWrapper<IdxBizJgOtherInfo>().lambda();
			lambda.eq(IdxBizJgOtherInfo::getClaimStatus, "已认领");
			lambda.in(IdxBizJgOtherInfo::getSupervisoryCode, supervisoryCode);
//			Integer integer = idxBizJgOtherInfoMapper.selectCount(lambda);
			List<IdxBizJgOtherInfo> idxBizJgOtherInfos = idxBizJgOtherInfoMapper.selectList(lambda);
			List<String> collect = idxBizJgOtherInfos.stream().map(IdxBizJgOtherInfo::getSupervisoryCode).collect(Collectors.toList());
			HashSet<String> strings1 = new HashSet<>(collect);
			if (supervisoryCode.size() != strings1.size() || supervisoryCode.size() != idxBizJgOtherInfos.size()) {
				throw new FileDownLoadException("监管码存在重复数据，请联系管理员！");
			}
		}
		if (ImageSizeEnums.DT.getCode().equals(type)) {
			for (JSONObject equipExportDatum : equipExportData.stream().filter(item -> !ObjectUtils.isEmpty(item.get("CODE96333"))).collect(Collectors.toList())) {
				InputStream bgImgFile = getClass().getClassLoader().getResourceAsStream("temp/" + imageSizeEnums.getBgPath());
				File QrCodeFile = File.createTempFile(equipExportDatum.get("CODE96333") + "+", ".png");
				ImageUtils.creatQRCode(QrCodeFile, bgImgFile, imageSizeEnums.getWith(), imageSizeEnums.getHeight(), REGULATORY_CODE_PREFIX + equipExportDatum.get("SUPERVISORY_CODE"), "", String.valueOf(equipExportDatum.get("CODE96333")), imageSizeEnums.getSize(), imageSizeEnums.getImagesX(), imageSizeEnums.getImagesY(), imageSizeEnums.getText1X(), imageSizeEnums.getText1Y(), imageSizeEnums.getText2X(), imageSizeEnums.getText2Y());
				fileList.add(new File(QrCodeFile.getAbsolutePath()));
				bgImgFile.close();
			}
		} else {
			for (JSONObject equipExportDatum : equipExportData.stream().filter(item -> !ObjectUtils.isEmpty(item.get("SUPERVISORY_CODE"))).collect(Collectors.toList())) {
				InputStream bgImgFile = getClass().getClassLoader().getResourceAsStream("temp/" + imageSizeEnums.getBgPath());
				File QrCodeFile = File.createTempFile(equipExportDatum.get("SUPERVISORY_CODE") + "+", ".png");
				ImageUtils.creatQRCode(QrCodeFile, bgImgFile, imageSizeEnums.getWith(), imageSizeEnums.getHeight(), REGULATORY_CODE_PREFIX + equipExportDatum.get("SUPERVISORY_CODE"), "", String.valueOf(equipExportDatum.get("SUPERVISORY_CODE")), imageSizeEnums.getSize(), imageSizeEnums.getImagesX(), imageSizeEnums.getImagesY(), imageSizeEnums.getText1X(), imageSizeEnums.getText1Y(), imageSizeEnums.getText2X(), imageSizeEnums.getText2Y());
				fileList.add(new File(QrCodeFile.getAbsolutePath()));
				bgImgFile.close();
			}
		}
		File zipFile = File.createTempFile("设备码信息", ".zip");
		// 调用压缩方法
		ImageUtils.zipFiles(fileList, zipFile, ".png");
		ImageUtils.downloadResourceZip("设备码信息.zip", zipFile.getAbsolutePath(), response);
		zipFile.delete();

	}


	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/saveSupervisoryData")
	@ApiOperation(httpMethod = "POST", value = "监管设备数据保存", notes = "监管设备保存")
	public ResponseModel<Boolean> saveSupervisoryData(@RequestBody EquipmentMessageDto data) {
		return ResponseHelper.buildResponse(equipmentCategoryServiceImpl.saveSupervisoryData(data));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/saveConstructionInfoData")
	@ApiOperation(httpMethod = "POST", value = "监管设备施工数据保存", notes = "监管设备施工数据保存")
	public ResponseModel<Boolean> saveConstructionInfoData(@RequestBody IdxBizJgConstructionInfo data) {
		return ResponseHelper.buildResponse(equipmentCategoryServiceImpl.saveConstructionInfoData(data));
	}
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/saveMaintenanceRecordInfoData")
	@ApiOperation(httpMethod = "POST", value = "监管设备维保数据保存", notes = "监管设备维保数据保存")
	public ResponseModel<Boolean> saveMaintenanceRecordInfoData(@RequestBody IdxBizJgMaintenanceRecordInfo data) {
		return ResponseHelper.buildResponse(equipmentCategoryServiceImpl.saveMaintenanceRecordInfoData(data));
	}
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/saveDetectionInfoData")
	@ApiOperation(httpMethod = "POST", value = "监管设备检验检测数据保存", notes = "监管设备检验检测数据保存")
	public ResponseModel<Boolean> saveDetectionInfoData(@RequestBody IdxBizJgInspectionDetectionInfo data) {
		return ResponseHelper.buildResponse(equipmentCategoryServiceImpl.saveDetectionInfoData(data));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/deleteByRecord")
	@ApiOperation(httpMethod = "POST", value = "数据异常回滚", notes = "数据异常回滚")
	public ResponseModel<Boolean> saveDetectionInfoData(@RequestParam("record") String record) {
		return ResponseHelper.buildResponse(equipmentCategoryServiceImpl.deleteByRecord(record));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/commonUpdateEsData")
	@ApiOperation(httpMethod = "POST", value = "更新ES中的数据（公共方法）", notes = "更新ES中的数据（公共方法）")
	public ResponseModel<Map<String, Object>> commonUpdateEsDataByIds(@RequestBody Map<String, Map<String, Object>> paramMap) {
		return ResponseHelper.buildResponse(equipmentCategoryService.commonUpdateEsDataByIds(paramMap));
	}
}
