package com.yeejoin.amos.boot.module.ccs.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireBuildingDto;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireBuildingServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 消防建筑表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "消防建筑表Api")
@RequestMapping(value = "/fire-building")
public class FireBuildingController extends BaseController {

    @Autowired
    FireBuildingServiceImpl fireBuildingServiceImpl;

    /**
     * 新增消防建筑表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增消防建筑表", notes = "新增消防建筑表")
    public ResponseModel<FireBuildingDto> save(@RequestBody FireBuildingDto model) {
        model = fireBuildingServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除消防建筑表", notes = "根据sequenceNbr删除消防建筑表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(fireBuildingServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个消防建筑表", notes = "根据sequenceNbr查询单个消防建筑表")
    public ResponseModel<FireBuildingDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(fireBuildingServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "消防建筑表分页查询", notes = "消防建筑表分页查询")
    public ResponseModel<Page<FireBuildingDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size) {
        Page<FireBuildingDto> page = new Page<FireBuildingDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(fireBuildingServiceImpl.queryForFireBuildingPage(page));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "消防建筑表列表全部数据查询", notes = "消防建筑表列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<FireBuildingDto>> selectForList() {
        return ResponseHelper.buildResponse(fireBuildingServiceImpl.queryForFireBuildingList());
    }
}
