package com.yeejoin.amos.boot.module.ccs.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireStationInfoDto;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireStationInfoServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * 站端信息表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "站端信息表Api")
@RequestMapping(value = "/fire-station-info")
public class FireStationInfoController extends BaseController {

    @Autowired
    FireStationInfoServiceImpl fireStationInfoServiceImpl;

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "站端信息表列表", notes = "站端信息表列表")
    @GetMapping(value = "/list")
    public ResponseModel<List<FireStationInfoDto>> selectForList() {
        return ResponseHelper.buildResponse(fireStationInfoServiceImpl.queryForFireStationInfoList());
    }
}
