package com.yeejoin.amos.boot.module.ccs.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireVideoDto;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireVideoServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 消防视频表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "消防视频表Api")
@RequestMapping(value = "/fire-video")
public class FireVideoController extends BaseController {

    @Autowired
    FireVideoServiceImpl fireVideoServiceImpl;

    /**
     * 新增消防视频表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增消防视频表", notes = "新增消防视频表")
    public ResponseModel<FireVideoDto> save(@RequestBody FireVideoDto model) {
        model = fireVideoServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新消防视频表", notes = "根据sequenceNbr更新消防视频表")
    public ResponseModel<FireVideoDto> updateBySequenceNbrFireVideo(@RequestBody FireVideoDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(fireVideoServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除消防视频表", notes = "根据sequenceNbr删除消防视频表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(fireVideoServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个消防视频表", notes = "根据sequenceNbr查询单个消防视频表")
    public ResponseModel<FireVideoDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(fireVideoServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "消防视频表分页查询", notes = "消防视频表分页查询")
    public ResponseModel<Page<FireVideoDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size) {
        Page<FireVideoDto> page = new Page<FireVideoDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(fireVideoServiceImpl.queryForFireVideoPage(page));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "消防视频表列表全部数据查询", notes = "消防视频表列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<FireVideoDto>> selectForList() {
        return ResponseHelper.buildResponse(fireVideoServiceImpl.queryForFireVideoList());
    }
}
