package com.yeejoin.amos.boot.module.ccs.biz.service.impl;

import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireEquipmentAlarmLogDto;
import com.yeejoin.amos.boot.module.ccs.api.entity.FireEquipmentAlarmLog;
import com.yeejoin.amos.boot.module.ccs.api.mapper.FireEquipmentAlarmLogMapper;
import com.yeejoin.amos.boot.module.ccs.api.service.IFireEquipmentAlarmLogService;
import com.yeejoin.amos.boot.module.ccs.biz.util.RequestUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 设备报警信息日志表服务实现类
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Service
public class FireEquipmentAlarmLogServiceImpl extends BaseService<FireEquipmentAlarmLogDto, FireEquipmentAlarmLog, FireEquipmentAlarmLogMapper> implements IFireEquipmentAlarmLogService {

    @Autowired
    HttpServletRequest request;

    /**
     * 告警列表查询-最新告警及跑马灯使用
     */
    public List<FireEquipmentAlarmLogDto> fireEquipmentAlarmLogList() {
        Map<String, Object> params = RequestUtil.getRequestParamMap(request);
        return this.getBaseMapper().queryAlarmLogList(params);
    }


    public List<FireEquipmentAlarmLogDto> todayAlarmLogList(String stationCode) throws ParseException {
        Map<String, Object> params = new HashMap<>();
        //未确认
        params.put("confirmState","0");
        params.put("beginDate", DateUtils.dateFormat(new Date(),DateUtils.DATE_PATTERN));
        params.put("endDate", DateUtils.dateFormat(new Date(),DateUtils.DATE_PATTERN));
        params.put("stationCode",stationCode);
        return this.getBaseMapper().queryAlarmLogList(params);
    }
}