package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 并网信息
 *
 * @author system_generator
 * @date 2024-01-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="HygfOnGridDto", description="并网信息")
public class HygfOnGridDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "并网申请")
    private String gridConnectionApplication;

    @ApiModelProperty(value = "并网回执")
    private String gridConnectionReceipt;

    @ApiModelProperty(value = "并网方案")
    private String gridConnectionScheme;

    @ApiModelProperty(value = "供电合同")
    private String powerSupplyContract;

    @ApiModelProperty(value = "购售合同")
    private String purchaseSaleContract;

    @ApiModelProperty(value = "并网协议")
    private String gridConnectionProtocol;

    @ApiModelProperty(value = "并网合同")
    private String gridConnectionContract;

    @ApiModelProperty(value = "光e宝")
    private String guangEBao;

    @ApiModelProperty(value = "开户行")
    private String bank;

    @ApiModelProperty(value = "户名")
    private String accountName;

    @ApiModelProperty(value = "账号")
    private String accountNumber;

    @ApiModelProperty(value = "合同到期时间")
    private Date contractExpirationDate;

    @ApiModelProperty(value = "有效发电开始日")
    private Date effectivePowerGenerationStartDate;

    @ApiModelProperty(value = "并网箱整体照片")
    private String overallPhotoGridCage;

    @ApiModelProperty(value = "表箱整体照片")
    private String electricMeterBox;

    @ApiModelProperty(value = "电表照片或视频")
    private String electricityMeter;

    @ApiModelProperty(value = "施工单id")
    private Long workOrderId;

    @ApiModelProperty(value = "施工电站id")
    private Long workOrderPowerStationId;

    @ApiModelProperty(value = "农户id")
    private Long peasantHouseholdId;

}
