package com.yeejoin.amos.boot.module.jxiop.biz.tdMapper2;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.FanHealthIndexDay;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.FanHealthIndexMoment;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

public interface FanHealthIndexMomentMapper extends BaseMapper<FanHealthIndexMoment> {
    @Select("<script>"+
            "SELECT `health_index` AS healthIndex,`health_index` AS `value`, anomaly, analysis_time AS  analysisTime,point_name as pointName,  station,equipment_name AS equipmentName,  ( CASE HEALTH_LEVEL WHEN '危险' THEN 3 WHEN '警告' THEN 2 WHEN '注意' THEN 1 ELSE 0 END ) AS status FROM analysis_data.fan_health_index_moment WHERE analysis_obj_type = #{analysisObjType}" +
            "<if test='endTimeTop!= null'>  and ts &lt;= #{endTimeTop} </if> " +
            "<if test='startTimeTop!= null'>  and  ts &gt;= #{startTimeTop} </if> " +
            "<if test='area!= null'> AND area = #{area} </if> " +
            "<if test='indexAddress!= null'> AND index_address = #{indexAddress} </if> " +
            "<if test='pointName!= null'>AND point_name = #{pointName} </if> " +
            "<if test='station!= null'>AND station = #{station} </if>" +
            "<if test='healthLevel!= null'>AND health_level = #{healthLevel} </if>" +
            "<if test='subSystem!= null'>AND sub_system = #{subSystem} </if> " +
            "<if test='equipmentName!= null'>AND equipment_name = #{equipmentName} </if>" +
            "<if test='gatewayIds != null and gatewayIds.size() > 0'><foreach collection='gatewayIds' item='gatewayId'>AND org_code like '%${gatewayId}%'</foreach></if>" +
            "order by health_index "+
            "<if test='current != null and size != null'>limit ${current},${size} </if>" +
            "</script>")
    List<FanHealthIndexMoment> selectData (@Param("healthLevel")String healthLevel, @Param("area")String area, @Param("equipmentName")String equipmentName, @Param("subSystem")String subSystem, @Param("analysisType")String analysisType, @Param("analysisObjType")String analysisObjType, @Param("station")String station, @Param("pointName")String pointName, @Param("indexAddress")String indexAddress, @Param("startTimeTop") String startTimeTop, @Param("endTimeTop")String endTimeTop, @Param("current")Integer current,@Param("size") Integer size,@Param("gatewayIds") List<String> gatewayIds);

}
