package com.yeejoin.amos.boot.module.jxiop.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jxiop.api.dto.StationCoordinateDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 场站基础信息表
 *
 * @author system_generator
 * @date 2023-04-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "station_basic",autoResultMap = true)
public class StationBasic extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 场站名称
     */
	@TableField("station_name")
    private String stationName;

    /**
     * 场站编号
     */
	@TableField("station_code")
    private String stationCode;


    /**
     * 场站类型
     */
    @TableField("station_type")
    private String stationType;

    @TableField("station_type_name")
    private String stationTypeName;
    /**
     * 项目状态
     */
    @TableField("station_flag")
    private String stationFlag;



    @TableField("address")
    private String address;

    /**
     * 站长
     */
	@TableField("station_master_name")
    private String stationMasterName;

    /**
     * 站长id
     */
	@TableField("station_master_id")
    private Integer stationMasterId;

    /**
     * 联系方式（手机）
     */
	@TableField("mobile_phone")
    private String mobilePhone;

    /**
     * 电话
     */
	@TableField("phone")
    private String phone;

    /**
     * 邮箱
     */
	@TableField("email")
    private String email;

    /**
     * 运维开始时间
     */
	@TableField("devops_time")
    private String devopsTime;

    /**
     * 所属地区
     */
	@TableField("belong_area")
    private String belongArea;
    /**
     * 所属地区名称
     */
    @TableField("area_name")
    private String areaName;

    @TableField(exist = false)
    private List<Integer> belongArealist;
    /**
     * 业主单位
     */
	@TableField("owner_unit")
    private String ownerUnit;

    /**
     * 简介
     */
	@TableField("brief_introduction")
    private String briefIntroduction;

    /**
     * 场站log
     */
	@TableField("station_logo")
    private String stationLogo;

    @TableField("area")
    private String area;
    @TableField("area_code")
    private String areaCode;
    @TableField("project_org_code")
    private String projectOrgCode;

    @TableField("platform_station_id")
    private String platformStationId;

    @TableField("jump_path")
    private String jumpPath;

    @TableField(exist =false)
    private List<StationCoordinate> stationCoordinate;
    //新增 场站第三方编号
    @TableField("station_number")
    private String stationNumber;
    //风机网管
    @TableField("fan_gateway_id")
    private String fanGatewayId;
    //升压站网管
    @TableField("booster_gateway_id")
    private String boosterGatewayId;
    //地图偏移量
    @TableField(value = "title_pos",typeHandler = FastjsonTypeHandler.class)
    private List<BigDecimal> titlePos;
    /**
     * 赋码颜色
     */
    @TableField("qrcode_color")
    private String qrcodeColor;
    /**
     * 前置网关配置的场站名称
     */
    @TableField("station_core_name")
    private String stationCoreName;
    /**
     * 前置配置的升压站名称
     */
    @TableField("booster_core_name")
    private String boosterCoreName;
    /**
     * 装机容量
     */
    @TableField("installed_capacity")
   private Double installedCapacity=0.0;
}
