package com.yeejoin.amos.boot.module.jxiop.biz.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.RegionNationWideDto;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.ResultsData;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.SeriesData;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface MonitorService {
    /**
     * @param areaCode 区域编码
     * @return 全国运维数据
     * @Description 根据区域编码动态运维数据
     */
    IPage<Map<String, Object>> operationData(String areaCode);

    /**
     * @return Map<String, Object>
     * @Description 全国新能源接入情况
     */
    Map<String, Object> accessSituation();

    /**
     * @return Map<String, Object>
     * @Description 区域新能源接入情况
     */
    Map<String, Object> qyAccessSituation();

    /**
     * @return List<RegionNationWideDto>
     * @Description 获取全国数据
     */
    Map<String, Object> gettimedateyfdqs();

    /**
     * @return List<RegionNationWideDto>
     * @Description 获取区域数据
     */
    Map<String, Object> gettimedateyfd(String areaName);



    /**
     * @return List<RegionNationWideDto>
     * @Description 获取区域数据
     */
    Map<String, Object> gettimedateqyyfd(String areaName);

    /**
     * @Description 获取全国的发电量趋势
     * @return SeriesData
     */
    SeriesData getSeriesDataqg();

    /**
     * @Description 根据areaCode获取全国发电量趋势
     * @param areaCode
     * @return SeriesData
     */
    SeriesData getSeriesDataqy(String areaCode);

    /**
     * @Descripiton 根据入参动态获取社会贡献
     * @param areaCode
     * @return
     */
    Page<HashMap<String, String>> socialContribution(String areaCode);
}
