package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import java.util.Date;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
/**
 * 微信消息 推送记录
 *
 * @author duanwei
 * @date 2021-07-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_wechat_send_message")
@ApiModel(value="WechatSendMessage对象", description="微信消息 推送记录")
public class WechatSendMessage extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "openId")
    private String openId;

    @ApiModelProperty(value = "内容")
    private String message;

    @ApiModelProperty(value = "状态 ： 成功 ，失败")
    private String status;

    @ApiModelProperty(value = "模板ID")
    private String templateId;

    @ApiModelProperty(value = "发送消息微信返回结果")
    private String result;

    @ApiModelProperty(value = "失败原因")
    private String failMessage;

}
