package com.yeejoin.amos.boot.module.command.api.dao;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import ch.qos.logback.core.net.SyslogOutputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import com.yeejoin.amos.boot.module.command.api.dto.SeismometeorologyDto;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Service;
/**
 * @description:
 * @author: tw
 * @createDate: 2021/7/19
 */
@Component
public class SeismometeorologyDtoDao {


    @Autowired
    private MongoTemplate mongoTemplate;

    /**
     * 保存对象SeismometeorologyDto
     * @param
     *
     */
    public void saveObj(SeismometeorologyDto book) {
        mongoTemplate.save(book);
    }



    /**
     *
     * 24小時预警
     *
     * **/
    public   List<SeismometeorologyDto> findCarStateByWatchSn(){
        Calendar calendar = Calendar.getInstance(); //创建Calendar 的实例
        calendar.add(Calendar.DAY_OF_MONTH,-1);
        System.out.println(new Date().getTime());
        Query query = new Query(Criteria.where("releaseTime").gte(calendar.getTimeInMillis()));
        Sort sort= Sort.by(Sort.Direction.DESC, "releaseTime");    
        query.with(sort);      
        List<SeismometeorologyDto> gpsList = mongoTemplate.find(query, SeismometeorologyDto.class);
        return gpsList;
    }


}

