package com.yeejoin.amos.boot.module.common.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 联动单位
 *
 * @author system_generator
 * @date 2021-07-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "LinkageUnitDto", description = "联动单位")
public class LinkageUnitDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "单位名称")
    private String unitName;

    @ApiModelProperty(value = "单位code")
    private String unitCode;

    @ApiModelProperty(value = "父级单位id")
    private String parentId;

    @ApiModelProperty(value = "联动单位类别")
    private String linkageUnitType;

    @ApiModelProperty(value = "联动单位类别code")
    private String linkageUnitTypeCode;

    @ApiModelProperty(value = "行政区划")
    private String administrativeDivisions;

    @ApiModelProperty(value = "行政区划代码")
    private String administrativeDivisionsCode;

    @ApiModelProperty(value = "地址")
    private String address;

    @ApiModelProperty(value = "经度")
    private Double longitude;

    @ApiModelProperty(value = "纬度")
    private Double latitude;

    @ApiModelProperty(value = "协议开始日期")
    private Date agreementStartDate;

    @ApiModelProperty(value = "协议结束日期")
    private Date agreementEndDate;

    @ApiModelProperty(value = "应急联动单位类别")
    private String emergencyLinkageUnit;

    @ApiModelProperty(value = "应急联动单位类别code")
    private String emergencyLinkageUnitCode;

    @ApiModelProperty(value = "联系人 ")
    private String contactUser;

    @ApiModelProperty(value = "联系人电话")
    private String contactPhone;

    @ApiModelProperty(value = "实例id")
    private Long instanceId;

    @ApiModelProperty(value = "组织机构代码")
    private String orgCode;

    @ApiModelProperty(value = "操作人名称")
    private String recUserName;

    @ApiModelProperty(value = "是否在协议期 ")
    private String inAgreement;

    @ApiModelProperty(value = "消防救援能力")
    private String fireRescueCapability;

    @ApiModelProperty(value = "职责_简要情况")
    private String responsibilitiesSituation;

    @ApiModelProperty(value = "应急服务内容")
    private String emergencyServiceContent;

    @ApiModelProperty(value = "单位_简要情况")
    private String unitSituation;

}
