package com.yeejoin.amos.boot.module.jcs.api.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
/**
* 警情报送记录
*
* @author tb
* @date 2021-06-17
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("jc_alert_submitted")
@ApiModel(value="AlertSubmitted对象", description="警情报送记录")
public class AlertSubmitted extends BaseEntity {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "警情id")
    private Long alertCalledId;

    @ApiModelProperty(value = "业务类型(警情续报、非警情确认、警情结案)")
    private String businessType;

    @ApiModelProperty(value = "业务类型code")
    private String businessTypeCode;

    @ApiModelProperty(value = "调度类型(融合调度、外部协调)")
    private String schedulingType;

    @ApiModelProperty(value = "调度类型code")
    private String schedulingTypeCode;

    @ApiModelProperty(value = "报送时间")
    private Date submissionTime;

    @ApiModelProperty(value = "通话记录id")
    private String callLogId;

    @ApiModelProperty(value = "发送人")
    private String sender;

    @ApiModelProperty(value = "报送方式(电话、短信)")
    private String submissionMethod;

    @ApiModelProperty(value = "报送方式code")
    private String submissionMethodCode;

    @ApiModelProperty(value = "报送内容")
    private String submissionContent;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
}
