package com.yeejoin.amos.boot.module.common.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.dto.SourceFileDto;
import com.yeejoin.amos.boot.module.common.api.entity.SourceFile;
import com.yeejoin.amos.boot.module.common.biz.service.impl.SourceFileServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 公共附件
 *
 * @author system_generator
 * @date 2021-07-16
 */
@RestController
@Api(tags = "公共附件Api")
@RequestMapping(value = "/common/source-file")
public class SourceFileController extends BaseController {

    @Autowired
    SourceFileServiceImpl sourceFileServiceImpl;

    /**
     * 新增公共附件
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增公共附件", notes = "新增公共附件")
    public ResponseModel<SourceFileDto> save(@RequestBody SourceFileDto model) {
        model = sourceFileServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新公共附件", notes = "根据sequenceNbr更新公共附件")
    public ResponseModel<SourceFileDto> updateBySequenceNbrSourceFile(@RequestBody SourceFileDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(sourceFileServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除公共附件", notes = "根据sequenceNbr删除公共附件")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(sourceFileServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个公共附件", notes = "根据sequenceNbr查询单个公共附件")
    public ResponseModel<SourceFileDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(sourceFileServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "公共附件分页查询", notes = "公共附件分页查询")
    public ResponseModel<Page<SourceFileDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size) {
        Page<SourceFileDto> page = new Page<SourceFileDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(sourceFileServiceImpl.queryForSourceFilePage(page));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "公共附件列表全部数据查询", notes = "公共附件列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<SourceFileDto>> selectForList() {
        return ResponseHelper.buildResponse(sourceFileServiceImpl.queryForSourceFileList());
    }

    /**
     * 附件批量保存
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "附件批量保存", notes = "附件批量保存")
    @PostMapping(value = "/saveBatch")
    public ResponseModel<List<SourceFile>> saveSourceFile(@RequestBody List<SourceFile> sourceFiles,
                                                          @RequestParam Long sourceId) {
        return ResponseHelper.buildResponse(sourceFileServiceImpl.saveSourceFile(sourceId, sourceFiles));
    }

    /**
     * 根据sourceId查询
     *
     * @param sourceId 附件所属者id
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sourceId}/list")
    @ApiOperation(httpMethod = "GET", value = "根据sourceId查询公共附件列表", notes = "根据sourceId查询公共附件列表")
    public ResponseModel<List<SourceFile>> queryBySourceId(@PathVariable Long sourceId) {
        return ResponseHelper.buildResponse(sourceFileServiceImpl.findBySourceId(sourceId));
    }
}
