package com.yeejoin.amos.boot.module.common.biz.service.impl;

import com.yeejoin.amos.boot.module.common.api.dto.OrgUsrDto;
import com.yeejoin.amos.boot.module.common.api.entity.MaintenanceCompany;
import com.yeejoin.amos.boot.module.common.api.enums.OrgPersonEnum;
import com.yeejoin.amos.boot.module.common.api.mapper.MaintenanceCompanyMapper;
import com.yeejoin.amos.boot.module.common.api.service.IMaintenanceCompanyService;
import com.yeejoin.amos.boot.module.common.api.dto.MaintenanceCompanyDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * 维保单位服务实现类
 *
 * @author system_generator
 * @date 2021-07-16
 */
@Service
public class MaintenanceCompanyServiceImpl extends BaseService<MaintenanceCompanyDto,MaintenanceCompany,MaintenanceCompanyMapper> implements IMaintenanceCompanyService {
    @Autowired
    DynamicFormInstanceServiceImpl dynamicFormInstanceService;
    /**
     * 分页查询
     */
    public Page<MaintenanceCompanyDto> queryForMaintenanceCompanyPage(Page<MaintenanceCompanyDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**en
     * 列表查询 示例
     */
    public List<MaintenanceCompanyDto> queryForMaintenanceCompanyList()   {
        return this.queryForList("" , false);
    }

    /**
     * 根据维保单位查询所有机场单位(返回List<Map>类型) 不带分页
     * @param seq
     * @return
     */
    public List< Map<String, Object>>  queryOrgUsrMsg(Long seq){
        if (ValidationUtil.isEmpty(this.queryBySeq(seq))){
            throw new BadRequest("参数校验失败.");
        }else {
            List<Map<String,Object>>  companys = new ArrayList<>();
            // 机场单位列表基本信息
            List<OrgUsrDto> orgUsrDtos = this.baseMapper.selectOrgUsrList(seq);
            // 机场组装单位动态表单数据
            orgUsrDtos.forEach(orgUsrDto -> {
                Map<String, Object> map = Bean.BeantoMap(orgUsrDto);
                mapCopy(dynamicFormInstanceService.getOneMap(orgUsrDto.getSequenceNbr(), OrgPersonEnum.公司.getKey()),map);
                companys.add(map);
            });
            return  companys;
        }
    }

    /**
     * 根据维保单位查询所有机场单位(返回List<Map>类型) 带分页
     * @param pageNum
     * @param pageSize
     * @param seq
     * @return
     */
    public List<Map<String,Object>>  queryOrgUsrMsgPage(int pageNum,int pageSize, Long seq){
        if (ValidationUtil.isEmpty(this.queryBySeq(seq))){
            throw new BadRequest("参数校验失败.");
        }else {
            List<Map<String,Object>>  companys = new ArrayList<>();
            // 机场单位列表基本信息
            List<OrgUsrDto> orgUsrDtos = this.baseMapper.selectOrgUsrPageList(pageNum,pageSize,seq);
            // 机场组装单位动态表单数据
            orgUsrDtos.forEach(orgUsrDto -> {
                Map<String, Object> map = Bean.BeantoMap(orgUsrDto);
                mapCopy(dynamicFormInstanceService.getOneMap(orgUsrDto.getSequenceNbr(), OrgPersonEnum.公司.getKey()),map);
                companys.add(map);
            });
            return  companys;
        }
    }

    public List<Map<String,Object>>  queryCompanyMsg (){
        List<Map<String,Object>>  companysMsg = new ArrayList<>();
        // 查询所有维保单位信息
        List<MaintenanceCompany> lists = this.list();
        lists.forEach(list->{
            Map<String,Object> maintenanceCompany = new HashMap<>();
            maintenanceCompany.put("id",list.getSequenceNbr());
            maintenanceCompany.put("code",list.getCode());
            maintenanceCompany.put("name",list.getName());
            maintenanceCompany.put("type",1);
            maintenanceCompany.put("parentId",null);
            // 查询该维保单位下的业主信息
            List<OrgUsrDto> orgUsrDtos = this.baseMapper.selectOrgUsrList(list.getSequenceNbr());
            orgUsrDtos.forEach(orgUsrDto -> {
                Map<String,Object> airCompany = new HashMap<>();
                airCompany.put("id",orgUsrDto.getSequenceNbr());
                airCompany.put("code",orgUsrDto.getBizOrgCode());
                airCompany.put("name",orgUsrDto.getBizOrgName());
                airCompany.put("type",2);
                airCompany.put("parentId",list.getSequenceNbr());
                companysMsg.add(airCompany);
            });
            companysMsg.add(maintenanceCompany);
        });
        return companysMsg;
    }

    /**
     * 复制map对象
     * @explain 将paramsMap中的键值对全部拷贝到resultMap中；
     * @param paramsMap
     *     被拷贝对象
     * @param resultMap
     *     拷贝后的对象
     */
    private static void mapCopy(Map paramsMap, Map resultMap) {
        if (resultMap == null) {
            return;
        }
        if (paramsMap == null) {
            return;
        }
        Iterator it = paramsMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry) it.next();
            Object key = entry.getKey();
            resultMap.put(key, paramsMap.get(key) != null ? paramsMap.get(key) : "");
        }
    }
}