package com.yeejoin.amos.boot.module.common.biz.service.impl;

import java.util.List;
import java.util.Optional;

import javax.annotation.Resource;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.utils.MenuFrom;
import com.yeejoin.amos.boot.module.common.api.dto.*;
import com.yeejoin.amos.boot.module.common.api.entity.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.utils.EnumsUtils;
import com.yeejoin.amos.boot.module.common.api.enums.WaterResourceTypeEnum;
import com.yeejoin.amos.boot.module.common.api.mapper.WaterResourceMapper;
import com.yeejoin.amos.boot.module.common.api.service.IWaterResourceService;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2021-06-29
 */
@Service
public class WaterResourceServiceImpl extends BaseService<WaterResourceDto, WaterResource, WaterResourceMapper> implements IWaterResourceService {

    @Autowired
    WaterResourceCraneServiceImpl waterResourceCraneService;
    @Autowired
    WaterResourceHydrantServiceImpl waterResourceHydrantService;
    @Autowired
    WaterResourceNaturalServiceImpl waterResourceNaturalService;
    @Autowired
    WaterResourcePoolServiceImpl waterResourcePoolService;
    @Autowired
    WaterResourceIotServiceImpl waterResourceIotService;
    @Resource
    WaterResourceMapper waterResourceMapper;

    /**
     * 分页查询
     */
    public Page<WaterResourceDto> queryForWaterResourcePage(Page<WaterResourceDto> page,
                                                            @Condition(Operator.like) String name,
                                                            @Condition(Operator.eq) String resourceType,
                                                            @Condition(Operator.eq) Boolean isDelete) {
        return this.queryForPage(page, null, false, name, resourceType, isDelete);
    }

    /**
     * 列表查询 示例
     */
    public List<WaterResourceDto> queryForWaterResourceList(@Condition(Operator.eq) Boolean isDelete) {
        return this.queryForList("", false, isDelete);
    }

    /**
     * 列表条件查询
     */
    public List<WaterResourceDto> queryWaterResourceList(@Condition(Operator.eq) Boolean isDelete,
                                                         @Condition(Operator.like) String name,
                                                         @Condition(Operator.eq) Long sequenceNbr,
                                                         @Condition(Operator.eq) Long belongFightingSystemId,
                                                         @Condition(Operator.eq) Long belongBuildingId,
                                                         @Condition(Operator.like) String belongBuilding,
                                                         @Condition(Operator.eq) String resourceType) {
        return this.queryForList("", false, isDelete, name, sequenceNbr, belongFightingSystemId, belongBuildingId,
                belongBuilding, resourceType);
    }


    /**
     * excel导入
     *
     * @param model
     * @return
     */
    public WaterResourceDto importByExcel(WaterResourceDto model) {
        String resourceType = model.getResourceType();
        Optional<WaterResourceTypeEnum> resourceTypeEnum = EnumsUtils.getEnumObject(WaterResourceTypeEnum.class,
                e -> e.getCode().equals(resourceType));
        model.setResourceTypeName(resourceTypeEnum.get().getName());
        model.setRealityImg(JSONArray.toJSONString(model.getRealityImgList()));
        model.setOrientationImg(JSONArray.toJSONString(model.getOrientationImgList()));
        if (!StringUtils.isEmpty(resourceType)) {
            switch (resourceType) {
                case "hydrant":
                    // 新增基础信息
                    model.setIsIot(true);
                    createWithModel(model);
                    // 新增属性信息
                    WaterResourceHydrantDto waterResourceHydrantDto = new WaterResourceHydrantDto();
                    BeanUtils.copyProperties(model, waterResourceHydrantDto);
                    waterResourceHydrantDto.setSequenceNbr(null);
                    waterResourceHydrantDto.setResourceId(model.getSequenceNbr());
                    waterResourceHydrantService.createWithModel(waterResourceHydrantDto);
                    break;
                case "crane":
                    // 新增基础信息
                    model.setIsIot(true);
                    createWithModel(model);
                    WaterResourceCraneDto waterResourceCraneDto = new WaterResourceCraneDto();
                    BeanUtils.copyProperties(model, waterResourceCraneDto);
                    waterResourceCraneDto.setSequenceNbr(null);
                    waterResourceCraneDto.setResourceId(model.getSequenceNbr());
                    waterResourceCraneService.createWithModel(waterResourceCraneDto);
                    break;
                case "natural":
                    // 新增基础信息
                    model.setIsIot(false);
                    createWithModel(model);
                    WaterResourceNaturalDto waterResourceNaturalDto = new WaterResourceNaturalDto();
                    BeanUtils.copyProperties(model, waterResourceNaturalDto);
                    waterResourceNaturalDto.setSequenceNbr(null);
                    waterResourceNaturalDto.setResourceId(model.getSequenceNbr());
                    waterResourceNaturalService.createWithModel(waterResourceNaturalDto);
                    break;
                case "pool":
                    // 新增基础信息
                    model.setIsIot(true);
                    createWithModel(model);
                    WaterResourcePoolDto waterResourcePoolDto = new WaterResourcePoolDto();
                    BeanUtils.copyProperties(model, waterResourcePoolDto);
                    waterResourcePoolDto.setSequenceNbr(null);
                    waterResourcePoolDto.setResourceId(model.getSequenceNbr());
                    waterResourcePoolService.createWithModel(waterResourcePoolDto);
                    break;
            }
            // 新增物联信息
            if (model.getIsIot()) {
                WaterResourceIotDto waterResourceIotDto = new WaterResourceIotDto();
                BeanUtils.copyProperties(model, waterResourceIotDto);
                waterResourceIotDto.setSequenceNbr(null);
                waterResourceIotDto.setResourceType(model.getResourceType());
                waterResourceIotDto.setResourceId(model.getSequenceNbr());
                waterResourceIotService.createWithModel(waterResourceIotDto);
            }
        } else {
            createWithModel(model);
        }
        return model;
    }

    /**
     * 导出列表
     */
    public List<WaterResourceDto> exportToExcel(@Condition(Operator.eq) Boolean isDelete) {
        return waterResourceMapper.exportToExcel(isDelete);
    }

    @Override
    public List<WaterResourceZhDto> getWaterResourceList(Integer pageNum, Integer pageSize, RequestData requestData) {
        if (null == pageNum || null == pageSize) {
            pageNum = 1;
            pageSize = Integer.MAX_VALUE;
        } else {
            pageNum = (pageNum - 1) * pageSize;
        }
        return waterResourceMapper.getWaterResourceList(pageNum, pageSize, requestData);
    }

    @Override
    public Integer getWaterResourceListCount(RequestData requestData) {
        return waterResourceMapper.getWaterResourceListCount(requestData);
    }

    @Override
    public WaterResourceDto selectBySequenceNbr(Long sequenceNbr) {
        // 查询基本信息
        WaterResourceDto waterResourceDto = this.queryBySeq(sequenceNbr);
        waterResourceDto.setRealityImgList(JSONArray.parseArray(waterResourceDto.getRealityImg(), Object.class));
        waterResourceDto.setOrientationImgList(JSONArray.parseArray(waterResourceDto.getOrientationImg()));
        Boolean isDelete = waterResourceDto.getIsDelete();
        // 查询属性信息
        String resourceType = waterResourceDto.getResourceType();
        if (!StringUtils.isEmpty(resourceType)) {
            switch (resourceType) {
                case "hydrant":
                    WaterResourceHydrant waterResourceHydrant =
                            waterResourceHydrantService.getOne(new QueryWrapper<WaterResourceHydrant>().eq(
                                    "resource_id",
                                    sequenceNbr));
                    BeanUtils.copyProperties(waterResourceHydrant, waterResourceDto);
                    break;
                case "crane":
                    WaterResourceCrane waterResourceCrane =
                            waterResourceCraneService.getOne(new QueryWrapper<WaterResourceCrane>().eq("resource_id",
                                    sequenceNbr));
                    BeanUtils.copyProperties(waterResourceCrane, waterResourceDto);
                    break;
                case "natural":
                    WaterResourceNatural waterResourceNatural =
                            waterResourceNaturalService.getOne(new QueryWrapper<WaterResourceNatural>().eq(
                                    "resource_id",
                                    sequenceNbr));
                    BeanUtils.copyProperties(waterResourceNatural, waterResourceDto);
                    break;
                case "pool":
                    WaterResourcePool waterResourcePool =
                            waterResourcePoolService.getOne(new QueryWrapper<WaterResourcePool>().eq("resource_id",
                                    sequenceNbr));
                    BeanUtils.copyProperties(waterResourcePool, waterResourceDto);
                    break;
            }
        }
        waterResourceDto.setSequenceNbr(sequenceNbr);
        waterResourceDto.setIsDelete(isDelete);
        // 查询物联参数
        if (waterResourceDto.getIsIot()) {
            WaterResourceIot waterResourceIot = waterResourceIotService.getOne(new QueryWrapper<WaterResourceIot>().eq(
                    "resource_id", sequenceNbr));
            WaterResourceIotDto waterResourceIotDto = new WaterResourceIotDto();
            BeanUtils.copyProperties(waterResourceIot, waterResourceIotDto);
            waterResourceDto.setWaterResourceIotDto(waterResourceIotDto);
        }
        return waterResourceDto;
    }

    public List<WaterResourceTypeDto> getWaterResourceTypeList(Boolean isDelete) {
        return waterResourceMapper.getWaterResourceTypeList(isDelete);
    }
}
