package com.yeejoin.amos.boot.module.tzs.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.tzs.api.dto.ElevatorDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.Elevator;
import com.yeejoin.amos.boot.module.tzs.api.service.IElevatorService;
import com.yeejoin.amos.boot.module.tzs.api.vo.ElevatorVo;
import com.yeejoin.amos.boot.module.tzs.biz.utils.BeanDtoVoUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Arrays;

/**
 * 电梯Api
 *
 * @author tb
 * @date 2021-06-01
 */
@RestController
@Api(tags = "电梯Api")
@RequestMapping(value = "/tzs/elevator")
public class ElevatorController extends BaseController {

    private final Logger logger = LoggerFactory.getLogger(ElevatorController.class);

    @Autowired
    IElevatorService iElevatorService;

    /**
     * 新增电梯
     *
     * @param elevatorDto 新增参数
     * @return 返回结果
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增电梯", notes = "新增电梯")
    public ResponseModel<Boolean> saveElevator(@RequestBody ElevatorDto elevatorDto) {
        Elevator elevator = BeanDtoVoUtils.convert(elevatorDto, Elevator.class);
        boolean save = iElevatorService.save(elevator);
        return ResponseHelper.buildResponse(save);
    }

    /**
     * 根据id删除
     *
     * @param id id
     * @return 返回结果
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public ResponseModel<Boolean> deleteById(@PathVariable Long id) {
        boolean remove = iElevatorService.removeById(id);
        return ResponseHelper.buildResponse(remove);
    }

    /**
     * 修改电梯
     *
     * @param elevatorDto 修改参数
     * @return 返回结果
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改电梯", notes = "修改电梯")
    public ResponseModel<Boolean> updateByIdElevator(@RequestBody ElevatorDto elevatorDto) {
        Elevator elevator = BeanDtoVoUtils.convert(elevatorDto, Elevator.class);
        boolean update = iElevatorService.updateById(elevator);
        return ResponseHelper.buildResponse(update);
    }


    /**
     * 根据id查询
     *
     * @param id id
     * @return 返回结果
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public ResponseModel<ElevatorVo> selectById(@PathVariable Long id) {
        Elevator elevator = iElevatorService.getById(id);
        ElevatorVo elevatorVo = BeanDtoVoUtils.convertElevatorToVo(elevator,false);
        return ResponseHelper.buildResponse(elevatorVo);
    }

    /**
     * 列表分页查询
     *
     * @param pageNum     当前页
     * @param pageSize    每页大小
     * @param elevatorDto 查询参数
     * @return 返回结果
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public ResponseModel<IPage<ElevatorVo>> listPage(String pageNum, String pageSize, ElevatorDto elevatorDto) {
        Elevator elevator = BeanDtoVoUtils.convert(elevatorDto, Elevator.class);
        Page<Elevator> pageBean;
        QueryWrapper<Elevator> elevatorQueryWrapper = new QueryWrapper<>();
        Class<? extends Elevator> aClass = elevator.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(elevator);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(elevator);
                        elevatorQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(elevator);
                        elevatorQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(elevator);
                        elevatorQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(elevator);
                        elevatorQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
                logger.error(e.getMessage());
            }
        });
        IPage<Elevator> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iElevatorService.page(pageBean, elevatorQueryWrapper);
        IPage<ElevatorVo> elevatorVoIPage = BeanDtoVoUtils.elevatorIPageVo(page);
        return ResponseHelper.buildResponse(elevatorVoIPage);
    }

    /**
     * 分页查询电梯信息
     *
     * @param pageNum     当前页
     * @param pageSize    每页大小
     * @param elevatorDto 查询参数
     * @return 查询结果
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/query_elevator_list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "分页查询电梯信息", notes = "分页查询电梯信息")
    public ResponseModel<IPage<ElevatorVo>> queryElevatorList(String pageNum, String pageSize,
                                                              ElevatorDto elevatorDto) {
        Elevator elevator = BeanDtoVoUtils.convert(elevatorDto, Elevator.class);
        Page<Elevator> pageBean;
        QueryWrapper<Elevator> elevatorQueryWrapper = new QueryWrapper<>();
        Class<? extends Elevator> aClass = elevator.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(elevator);
                if (o != null) {
                    String name = NameUtils.camel2Underline(field.getName());
                    if ("rescue_code".equalsIgnoreCase(name)) {
                        Integer fileValue = (Integer) o;
                        elevatorQueryWrapper.like(name, fileValue);
                    } else if ("city".equalsIgnoreCase(name) || "district".equalsIgnoreCase(name)) {
                        String fileValue = (String) o;
                        elevatorQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) o;
                        elevatorQueryWrapper.like(name, fileValue);
                    }
                }
            } catch (Exception e) {
                logger.error(e.getMessage());
            }
        });
        IPage<Elevator> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iElevatorService.page(pageBean, elevatorQueryWrapper);
        IPage<ElevatorVo> elevatorVoIPage = BeanDtoVoUtils.elevatorIPageVo(page);
        return ResponseHelper.buildResponse(elevatorVoIPage);
    }
}

