package com.yeejoin.amos.boot.module.common.api.mapper;

import java.util.List;
import java.util.Map;

import com.yeejoin.amos.boot.module.common.api.dto.*;

import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.biz.common.utils.FirefightersTreeDto;
import com.yeejoin.amos.boot.module.common.api.entity.Firefighters;

/**
 * 消防队员 Mapper 接口
 *
 * @author tb
 * @date 2021-06-07
 */
public interface FirefightersMapper extends BaseMapper<Firefighters> {


    List<FirefightersZhDto> getFirefighters(@Param("pageNum") int pageNum, @Param("pageSize") int pageSize,
                                            @Param("par") FirefightersDto par);

    Map<String, Long> getFirefightersCount(@Param("pageNum") int pageNum, @Param("pageSize") int pageSize, @Param(
            "par") FirefightersDto par);

    Map<String, Object> listToSelectById(@Param("id") Long id);

    List<FirefightersTreeDto> getFirefightersJobTitleCount(String bizOrgCode);

    List<Map<String, String>> getFirefightersName();

    List<FirefightersExcelDto> exportToExcel(Boolean isDelete, String name, String postQualification, String fireTeamId,
                                             String state, String areasExpertise, String jobTitle, String bizOrgCode);

    List<FirefightersDto> queryById(@Param("gw") String[] gw, @Param("name") String name);

    List<Map<String, String>> selectNormalFirePerson(String jobId);

    List<Firefighters> getPersonByCodes(@Param("list") List<String> list);

    List<OrgUsrFireExcelDto> exportToExcelNew(Boolean isDelete, String name, String postQualification, String fireTeamId, String state, String areasExpertise, String jobTitle, String bizOrgCode);

    Integer getTeamCountByCode(@Param("companyCode") String companyCode);

    Map<String, Object> getFireForceInfoByCode(@Param("bizOrgCode") String bizOrgCode);

    List<Map<String, Object>> getStationSignInfo(@Param("bizOrgCode") String bizOrgCode);

    List<Map<String, Object>> getUsrSignInfoByBizOrgCode(@Param("bizOrgCode") String bizOrgCode);
}
