package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import java.util.Date;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
/**
 * 风险管控任务表
 *
 * @author duanwei
 * @date 2021-11-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_task_risk_control_tech")
@ApiModel(value="TaskRiskControlTech对象", description="风险管控任务表")
public class TaskRiskControlTech extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "任务id")
    private Long taskId;

    @ApiModelProperty(value = "阶段")
    private Integer stage;

    @ApiModelProperty(value = "技术负责人id")
    private Long techPersonId;

    @ApiModelProperty(value = "是否考试")
    private Integer isExam;

    @ApiModelProperty(value = "是否知识")
    private Integer isKnowledge;

    @ApiModelProperty(value = "组织机构代码")
    private String orgCode;

    @ApiModelProperty(value = "任务完成时间")
    private Date taskEndTime;

    @ApiModelProperty(value = "进入风险区域累计人数")
    private Integer personCount;

    @ApiModelProperty(value = "风险作业id")
    private Long taskRiskControlId;

    @ApiModelProperty(value = "项目id")
    private Long projectId;

    @ApiModelProperty(value = "类型 0 1 2")
    private Integer type;

    @ApiModelProperty(value = "施工方案id")
    private Long constructDocumentId;

    @ApiModelProperty(value = "技术交底书id")
    private Long techDocumentId;

    @ApiModelProperty(value = "作业名称")
    private String name;

    @ApiModelProperty(value = "施工方案交底任务id(type1使用)")
    private Long constructTaskRiskControlTechId;

    @ApiModelProperty(value = "施工方案交底任务名称(type2使用)")
    private String constructTaskRiskControlName;

    @ApiModelProperty(value = "施工方案交底书id")
    private Long constructDisclosureDocumentId;
}
