package com.yeejoin.amos.boot.module.common.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.common.api.dto.OrgUsrSyncDto;
import com.yeejoin.amos.boot.module.common.api.enums.DataSyncTopicEnum;
import com.yeejoin.amos.boot.module.common.api.mapper.OrgUsrMapper;
import com.yeejoin.amos.boot.module.common.api.service.IDataSyncService;
import com.yeejoin.amos.component.rule.config.RuleConfig;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.component.emq.EmqKeeper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Async
@Slf4j
public class DataSyncServiceImpl implements IDataSyncService {

    @Autowired
    private EmqKeeper emqKeeper;

    @Autowired
    private OrgUsrMapper orgUsrMapper;

    @Value("${emq.orgUsr.sync.switch}")
    private Boolean orgUsrSyncSwitch;

    @Override
    public void OrgUsrSyncDtoDataSync(Long id) {
        try {
            if (id != null) {
                Map<String, Object> map = new HashMap<>();
                map.put("id", id);
                List<OrgUsrSyncDto> list = orgUsrMapper.getOrgUsrSyncDataList(map);
                if (CollectionUtils.isNotEmpty(list)) {
                    for (OrgUsrSyncDto x : list) {
                        String message = buildSyncMessage(DataSyncTopicEnum.ORG_USR.getTopic(), x);
                        emqKeeper.getMqttClient().publish(DataSyncTopicEnum.EQM_PATROL_CREATED.getTopic(), message.getBytes(), RuleConfig.DEFAULT_QOS, false);
                        if (orgUsrSyncSwitch) {
                            emqKeeper.getMqttClient().publish(DataSyncTopicEnum.ORG_USR.getTopic(), JSONObject.toJSONString(x).getBytes(), RuleConfig.DEFAULT_QOS, false);
                        }
                    }
                }
            }
        } catch (Exception e) {
            log.error("站端与中心级人员数据【OrgUsrSyncDto】同步推送失败-----------" + e.getMessage());
        }
    }

    @Override
    public void OrgUsrSyncDtoDelDataSync(Long id) {
        try {
            if (id != null) {
                //  同步删除人员信息
                OrgUsrSyncDto orgUsrSyncDto = new OrgUsrSyncDto();
                orgUsrSyncDto.setSequenceNbr(id);
                String message = buildSyncMessage(DataSyncTopicEnum.ORG_USR_DEL.getTopic(), orgUsrSyncDto);
                emqKeeper.getMqttClient().publish(DataSyncTopicEnum.EQM_PATROL_CREATED.getTopic(), message.getBytes(), RuleConfig.DEFAULT_QOS, false);
                if (orgUsrSyncSwitch) {
                    emqKeeper.getMqttClient().publish(DataSyncTopicEnum.ORG_USR_DEL.getTopic(), JSONObject.toJSONString(orgUsrSyncDto).getBytes(), RuleConfig.DEFAULT_QOS, false);
                }
            }
        } catch (Exception e) {
            log.error("站端与中心级人员数据【OrgUsrSyncDto】同步推送失败-----------" + e.getMessage());
        }
    }

    public String buildSyncMessage(String topic, Object object) {
        Map<String, Object> map = new HashMap<>();
        map.put("topic", topic);
        map.put("data", object);
        return JSONObject.toJSONString(map);
    }
}
