package com.yeejoin.amos.boot.module.jczs.api.dto;

    import java.util.Date;
import java.util.List;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.jczs.api.entity.TzsJgFile;

    import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
/**
* 特种设备基本信息-注册登记信息 Dto
*
* @author duanwei
* @date 2022-07-26
*/
@Data
public class TzsJgRegistrationInfoDto extends BaseDto {

    private static final long serialVersionUID = 1L;

            @ApiModelProperty(value = "id")
    /**
    * id
    */
    private Long sequenceNbr;
            @ApiModelProperty(value = "设备唯一标识码")
    /**
    * 设备唯一标识码
    */
    private String sequenceCode;
            @ApiModelProperty(value = "监管系统唯一编码")
    /**
    * 监管系统唯一编码
    */
    private String superviseCode;
            @ApiModelProperty(value = "登记机关组织机构代码")
    /**
    * 登记机关组织机构代码
    */
    private String organizationCode;
            @ApiModelProperty(value = "登记机关名称")
    /**
    * 登记机关名称
    */
    private String organizationName;
            @ApiModelProperty(value = "使用登记证编号")
    /**
    * 使用登记证编号
    */
    private String useOrgCode;
            @ApiModelProperty(value = "注册状态(已注册 未注册)")
    /**
    * 注册状态(已注册 
未注册)
    */
    private String registerState;
            @ApiModelProperty(value = "使用登记ID")
    /**
    * 使用登记ID
    */
    private String useOrgId;
            @ApiModelProperty(value = "设备代码")
    /**
    * 设备代码
    */
    private String equCode;
            @ApiModelProperty(value = "设备种类")
    /**
    * 设备种类
    */
    private String equList;
            @ApiModelProperty(value = "设备类别")
    /**
    * 设备类别
    */
    private String equCategory;
            @ApiModelProperty(value = "设备品种")
    /**
    * 设备品种
    */
    private String equDefine;
            @ApiModelProperty(value = "产品名称")
    /**
    * 产品名称
    */
    private String productName;
            @ApiModelProperty(value = "品牌名称")
    /**
    * 品牌名称
    */
    private String brandName;
            @ApiModelProperty(value = "设备型号")
    /**
    * 设备型号
    */
    private String equType;
            @ApiModelProperty(value = "设备总价值（万元）")
    /**
    * 设备总价值（万元）
    */
    private Double equPrice;
            @ApiModelProperty(value = "同步时间")
    /**
    * 同步时间
    */
    private Date syncDate;
            @ApiModelProperty(value = "同步状态（0-新增   1-更新   2-删除）")
    /**
    * 同步状态（0-新增   1-更新   2-删除）
    */
    private Integer syncState;
            @ApiModelProperty(value = "对接公司编码")
    /**
    * 对接公司编码
    */
    private String appId;
            @ApiModelProperty(value = "创建时间")
    /**
    * 创建时间
    */
    private Date recDate;
            @ApiModelProperty(value = "操作人员")
    /**
    * 操作人员
    */
    private String recUserId;
            
    private List<TzsJgFile> useRegistCertificate;
}
