package com.yeejoin.amos.api.openapi.face.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
* 特种设备基本信息-制造信息Vo
*
* @author duanwei
* @date 2022-07-20
*/
@EqualsAndHashCode(callSuper = true)
@Data
public class ProduceInfoModel extends AbstractBaseModel {

    private static final long serialVersionUID = 1L;

    private List produceStandard;
    private List productCertificate;
    private List iumInstructions;
    private List supervisionCert;
    private List ceCert;


            @ApiModelProperty(value = "设备唯一标识码")
    /**
    * 设备唯一标识码
    */
    private String sequenceCode;
            @ApiModelProperty(value = "监管系统唯一编码")
    /**
    * 监管系统唯一编码
    */
    private String superviseCode;
            @ApiModelProperty(value = "制造单位统一社会信用代码")
    /**
    * 制造单位统一社会信用代码
    */
    private String produceUnitCreditCode;
            @ApiModelProperty(value = "制造单位名称")
    /**
    * 制造单位名称
    */
    private String produceUnitName;
            @ApiModelProperty(value = "制造许可编号")
    /**
    * 制造许可编号
    */
    private String produceLicenseNum;
            @ApiModelProperty(value = "出厂编号")
    /**
    * 出厂编号
    */
    private String factoryNum;
            @ApiModelProperty(value = "制造日期")
    /**
    * 制造日期
    */
    private Date produceDate;
            @ApiModelProperty(value = "是否进口(是、否)")
    /**
    * 是否进口(是、否)
    */
    private String imported;
            @ApiModelProperty(value = "制造国")
    /**
    * 制造国
    */
    private String produceCountry;
            @ApiModelProperty(value = "监督检验ID")
    /**
    * 监督检验ID
    */
    private String inspectionId;
            @ApiModelProperty(value = "型式试验ID")
    /**
    * 型式试验ID
    */
    private String typeTestId;



}
