package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 信号分类量测枚举表
 *
 * @author system_generator
 * @date 2023-02-18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_fault_case")
public class FaultCase extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
	@TableField("id")
    private Long id;

    /**
     * 系统id
     */
	@TableField("system_id")
    private String systemId;

    /**
     * 系统名称
     */
	@TableField("system_name")
    private String systemName;

    /**
     * 部件id
     */
	@TableField("equip_code")
    private String equipCode;

    /**
     * 部件名称
     */
	@TableField("equip_name")
    private String equipName;

    /**
     * 故障等级
     */
	@TableField("fault_level")
    private String faultLevel;

    /**
     * 故障类型
     */
    @TableField("fault_type")
    private String faultType;

    /**
     * 故障描述
     */
    @TableField("fault_describe")
    private String faultDescribe;

    /**
     * 处理建议
     */
    @TableField("handle_advise")
    private String handleAdvise;

    /**
     * 故障影响
     */
    @TableField("fault_effect")
    private String faultEffect;

    /**
     * 预防措施
     */
    @TableField("preventive_measure")
    private String preventiveMeasure;

    @TableField(exist = false)
    private String searchName;
}
