package com.yeejoin.equipmanage.common.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author keyong
 * @title: TopicEnum
 * <pre>
 * @description: 数字换流站数据刷新的订阅主题
 * </pre>
 * @date 2021/5/19 13:35
 */
@Getter
@AllArgsConstructor
public enum TopicEnum {
    EQDQR("fasAlarmInsert", "今日消防警情-待确认"),
    EQYQR("fasAlarmConfirm", "今日消防警情-已确认"),
    EQZXDT("fasAlarmInsertOrUpdate", "最新动态-告警日志列表"),
    CARZXDT("carIndexInsertOrUpdate", "最新动态-告警日志列表"),
    EQXXTJ("fasReportInsertOrUpdate", "设备信号消息统计列表"),
    ALARM_LOG_INSERT("alarm/log/insert","告警日志插入"),
    IOT_SYSTEM__AlARM("iot-system-alarm", "确警消息"),
    SHBZYCXH("fasNormalIndexInsertOrUpdate", "四横八纵遥测信号"),
    XFXTYXZT("fasFireSystemRunStateUpdate", "站端消防系统运行状态更新主题");

    private String topic;

    private String describe;
}
