package com.yeejoin.precontrol.common.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 *  奖励兑换记录
 *
 * @author duanwei
 * @date 2021-04-06
 */
@Data
public class RewardListVo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "奖励人id")
    /**
     * 奖励人id
     */
    private Long personId;
    @ApiModelProperty(value = "奖励人姓名")
    /**
     * 奖励人奖励人姓名
     */
    private String userName;
    @ApiModelProperty(value = "任务id")
    /**
     * 任务id
     */
    private Long taskId;
    @ApiModelProperty(value = "单号")
    /**
     * 单号
     */
    private String taskNo;
    @ApiModelProperty(value = "任务类型")
    /**
     * 任务类型
     */
    private String taskType;
    @ApiModelProperty(value = "名称")
    /**
     * 名称
     */
    private String taskName;
    @ApiModelProperty(value = "任务状态Code")
    /**
     * 状态Code
     */
    private String statusCode;
    @ApiModelProperty(value = "任务状态描述")
    /**
     * 状态描述
     */
    private String statusValue;
    @ApiModelProperty(value = "奖励金额")
    /**
     * 奖励金额
     */
    private BigDecimal money;
    @ApiModelProperty(value = "状态（0-未兑换，1-已兑换）")
    /**
     * 状态（0-未兑换，1-已兑换）
     */
    private Integer status;
    @ApiModelProperty(value = "兑换日期")
    /**
     * 兑换日期
     */
    private Date exchangeDate;
    @ApiModelProperty(value = "开始日期")
    /**
     * 开始日期
     */
    private Date startDate;
    @ApiModelProperty(value = "结束日期")
    /**
     * 结束日期
     */
    private Date endDate;
    /**
     * 违章类型
     */
    @ApiModelProperty(value = "违章类型")
    private String nature;
    /**
     * 违章分类
     */
    @ApiModelProperty(value = "违章分类")
    private String type;

}
