package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.pagehelper.util.StringUtil;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jcs.api.entity.OrganizationUser;
import com.yeejoin.amos.boot.module.jcs.api.mapper.OrganizationUserMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IOrganizationUserService;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;
import java.util.stream.Collectors;

@Service
public class OrganizationUserImpl extends BaseService<OrganizationUser,OrganizationUser, OrganizationUserMapper> implements IOrganizationUserService {
    @Override
    public OrganizationUser saveOrganization(OrganizationUser organizationUser) {
        return this.createWithModel(organizationUser);
    }

    @Override
    public OrganizationUser updateModelById(OrganizationUser organizationUser) {
        return this.updateWithModel(organizationUser);
    }

    @Override
    public void updateModelByTel(OrganizationUser organizationUser) {
        QueryWrapper<OrganizationUser> oldQuery = new QueryWrapper<>();
        oldQuery.eq("duty_leader", 1);
        List<OrganizationUser> oldList = this.baseMapper.selectList(oldQuery);
        if (0 < oldList.size()) {
            oldList.forEach(x -> {
                x.setDutyLeader(false);
                this.baseMapper.updateById(x);
            });
        }

        LambdaQueryWrapper<OrganizationUser> wrapper = new LambdaQueryWrapper<>();
        if (!ObjectUtils.isEmpty(organizationUser.getTelephone())) {
            wrapper.eq(OrganizationUser::getTelephone, organizationUser.getTelephone());
        } else if (!ObjectUtils.isEmpty(organizationUser.getSequenceNbr())) {
            wrapper.eq(OrganizationUser::getSequenceNbr, organizationUser.getSequenceNbr());
        }
        List<OrganizationUser> newList = this.baseMapper.selectList(wrapper);
        newList.forEach(x -> {
            x.setDutyLeader(true);
            this.baseMapper.updateById(x);
        });
    }

    @Override
    public OrganizationUser getDetailsById(Long id) {
        return this.baseMapper.selectById(id);
    }

    @Override
    public IPage<OrganizationUser> getListPage(int pageNumber, int pageSize, Long id) {
        Page<OrganizationUser> page = new Page<>();
        page.setSize(pageSize);
        page.setCurrent(pageNumber);

        LambdaQueryWrapper<OrganizationUser> wrapper = new LambdaQueryWrapper<>();
        if (!ObjectUtils.isEmpty(id) && id != 0) {
            wrapper.eq(OrganizationUser::getEmergencyTeamId, id);
        }
        wrapper.eq(OrganizationUser::getIsDelete, false);
        wrapper.orderByDesc(OrganizationUser::getSort);
        return this.baseMapper.selectPage(page, wrapper);
    }

    @Override
    public IPage<OrganizationUser> getPage(int pageNumber, int pageSize, String tel) {
        Page<OrganizationUser> page = new Page<>();
        page.setSize(pageSize);
        page.setCurrent(pageNumber);

        LambdaQueryWrapper<OrganizationUser> wrapper = new LambdaQueryWrapper<>();
        if (StringUtil.isNotEmpty(tel)) {
            wrapper.eq(OrganizationUser::getTelephone, tel);
        }
        wrapper.eq(OrganizationUser::getIsDelete, false);
        wrapper.orderByDesc(OrganizationUser::getSort);
        wrapper.groupBy(OrganizationUser::getTelephone);
        return this.baseMapper.selectPage(page, wrapper);
    }

    @Override
    public int deleteById(Long id) {
        return this.baseMapper.deleteById(id);
    }
}
