package com.yeejoin.precontrol.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import org.springframework.boot.jackson.JsonComponent;

import java.io.IOException;
import java.text.SimpleDateFormat;

/**
 * @description:
 * @author: duanwei
 * @date: 2020-07-09 14:11
 **/
@JsonComponent
public class DateFormatConfig {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

//    /**
//     * 日期格式化
//     */
//    public static class DateJsonSerializer extends JsonSerializer<Date> {
//        @Override
//        public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
//            jsonGenerator.writeString(dateFormat.format(date));
//        }
//    }
//
//    /**
//     * 解析日期字符串
//     */
//    public static class DateJsonDeserializer extends JsonDeserializer<Date> {
//        @Override
//        public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
//            try {
//                return dateFormat.parse(jsonParser.getText());
//            } catch (ParseException e) {
//                throw new RuntimeException(e);
//            }
//        }
//    }

    /**
     * id主键
     */
    public static class LongJsonSerializer extends JsonSerializer<Long> {
        @Override
        public void serialize(Long id, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(String.valueOf(id));
        }
    }
}
