package com.yeejoin.amos.boot.module.tzs.flc.biz.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.EquipmentInformDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.InformProcessInfoDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.entity.EquipmentInform;
import com.yeejoin.amos.boot.module.tzs.flc.api.entity.InformProcessInfo;
import com.yeejoin.amos.boot.module.tzs.flc.api.mapper.InformProcessInfoMapper;
import com.yeejoin.amos.boot.module.tzs.flc.api.service.IInformProcessInfoService;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;

/**
 * 通话记录附件服务实现类
 *
 * @author system_generator
 * @date 2021-12-27
 */
@Service
public class InformProcessInfoServiceImpl extends BaseService<InformProcessInfoDto,InformProcessInfo,InformProcessInfoMapper> implements IInformProcessInfoService {

    @Autowired
    EquipmentInformServiceImpl equipmentInformServiceImpl;


    /**
     * 分页查询
     */
    public Page<InformProcessInfoDto> queryForInformProcessInfoPage(Page<InformProcessInfoDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<InformProcessInfoDto> queryForInformProcessInfoList()   {
        return this.queryForList("" , false);
    }

    @Override
    @Transactional
    public Boolean saveProcessInfo(EquipmentInformDto model, ReginParams userInfo, String processStage) throws Exception {

        // 记录 流程操作人 所属单位 流程状态 和动作
        InformProcessInfoDto info = new InformProcessInfoDto();
        AgencyUserModel user = userInfo.getUserModel();
        List<CompanyModel> companys = user.getCompanys();
        CompanyModel company = null;
        if(companys != null && companys.size() >0) {
            company = companys.get(0);
            info.setHandlerUnit(company.getCompanyName());
            info.setHandlerUnitId(company.getSequenceNbr());
        }
        info.setHandlerId(Long.parseLong(user.getUserId()));
        info.setHandler(user.getRealName());
        info.setProcessId(model.getProcessId());
        info.setInformId(model.getSequenceNbr());
        info.setProcessInfo(processStage);
        info.setProcessStatus(model.getProcessStatus());
        this.createWithModel(info);
        return true;
    }
}