package com.yeejoin.amos.file.service;

import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

import javax.imageio.ImageIO;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.fit.pdfdom.PDFDomTree;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.aspose.words.License;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.SimpleBookmark;
import com.itextpdf.text.pdf.parser.PdfTextExtractor;
import com.yeejoin.amos.file.config.MatchLicense;
import com.yeejoin.amos.file.convert.DocConvert;
import com.yeejoin.amos.file.convert.HTMLConvert;
import com.yeejoin.amos.file.dto.CatalogInfo;
import com.yeejoin.amos.file.dto.ChildCatalog;
import com.yeejoin.amos.file.utils.HelpUtil;


@Service
public class SpiltService {
	
	/**
	   * 按行提取文本
	   * @param file
	   * @return List<String>
	   */
	  public static List<String> extractTXTbyLine(String file) {
	    List<String> listArr = new ArrayList<String>();
	    try {
	      PdfReader reader = new PdfReader(file);
	      int pageNum = reader.getNumberOfPages(); // 获得页数
	      for (int i = 1; i <= pageNum; i++) { // 只能从第1页开始读
	        String textFromPageContent = PdfTextExtractor.getTextFromPage(reader, i);
	        String[] splitArray = textFromPageContent.split("\n");
	        if (splitArray.length > 0) {
	          listArr.addAll(Arrays.asList(splitArray));
	        }
	      }
	    } catch (IOException ex) {
	      ex.printStackTrace();
	    }
	    return listArr;
	  }
	/*
    pdf转换html
     */
    public static void pdfToHtmlTest(String inPdfPath,String outputHtmlPath)  {
       // String outputPath = "C:\\works\\files\\ZSQ保密知识测试题库.html";
            //try() 写在()里面会自动关闭流
       try{
           BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(outputHtmlPath)),"utf-8"));
           //加载PDF文档
           //PDDocument document = PDDocument.load(bytes);
           PDDocument document = PDDocument.load(new File(inPdfPath));
           PDFDomTree pdfDomTree = new PDFDomTree();
           pdfDomTree.writeText(document,out);
       } catch (Exception e) {
           e.printStackTrace();
       }
   }

//   public static void main(String[] args) throws IOException {
//       String pdfPath="F:\\\\文档\\\\空工大\\\\使用维护说明书-20221024.pdf";
////       String outputPath="F:\\\\文档\\\\空工大\\\\使用维护说明书-20221024.html";
////       pdfToHtmlTest(pdfPath,outputPath);
//       
//       List<String> strings = extractTXTbyLine(pdfPath);
//       for (String s : strings) {
//         System.out.println(s);
//       }
// }
   
    
    public static void main(String[] args) throws Exception {
    	
    	try {
            /*
              实现匹配文件授权 -> 去掉头部水印 `Evaluation Only. Created with Aspose.Words. Copyright 2003-2018 Aspose Pty Ltd.` |
                                          `Evaluation Only. Created with Aspose.Cells for Java. Copyright 2003 - 2020 Aspose Pty Ltd.`
             */
    		File file = new File("E:\\test\\test1\\license.xml");
            InputStream is =  new FileInputStream(file);
            License license = new License();
            license.setLicense(is);
        } catch (Exception e) {
        	e.printStackTrace();
        }
    	MatchLicense.init();
		String filePath = "E:\\test\\test1\\test.pdf";
		String htmlpath = "E:\\test\\test1\\test.html";
		HTMLConvert.pdf2html(filePath, htmlpath);
//		DocConvert.pdf2docx(filePath, htmlpath);
//		HTMLConvert.pdf2html2(filePath, htmlpath);
	}
   
	
//	public static void main(String[] args) {
//		String filePath = "E:\\test\\test1\\使用维护说明书-20221024.pdf";
//		String fileName = "使用维护说明书-20221024.pdf";
//		try {
//			CatalogInfo catalogInfo = getCatalog(filePath, fileName);
//			JSONObject json = (JSONObject) JSONObject.toJSON(catalogInfo);
//			System.out.println(json.toString());
//		} catch (IOException e) {
//			e.printStackTrace();
//		}
//	}
	
	public static CatalogInfo getCatalog(String filePath, String bookName) throws IOException {
		 PdfReader pdfReader = null;
		 pdfReader = new PdfReader(filePath);
		
		CatalogInfo catalogInfo = new CatalogInfo();
        catalogInfo.setDocumentName(bookName);
        catalogInfo.setTotalPage(pdfReader.getNumberOfPages());
        List<HashMap<String, Object>> list = SimpleBookmark.getBookmark(pdfReader);
        if (list != null) {
            list.forEach(it -> {
                if (it.get("Page") != null) {
                    int j = 1;
                    ChildCatalog childCatalog = new ChildCatalog();
                    //层级
                    childCatalog.setCatalogLevel(j);
                    //目录id
                    childCatalog.setCatalogId(HelpUtil.generateId());
                    childCatalog.setCatalogName(it.get("Title") == null ? "" : it.get("Title").toString());
                    //获取目录 所在 文件 位置
                    String pagePosition = it.get("Page").toString();
                    showBookmark(it, j, childCatalog);
                    getPosition(childCatalog, pagePosition);
                    catalogInfo.getChildCatalogList().add(childCatalog);
                }

            });
        }
        return catalogInfo;
	}

    public static void spiltPdf(String bookId, String bookUrl, String bookName, String filePath, String filePrefix) throws Exception {
        if (!bookUrl.endsWith(".pdf")) {
            throw new Exception("不是pdf文件");
        }
        if (bookUrl.startsWith(filePrefix)) {
            bookUrl = bookUrl.substring(filePrefix.length());
        }
        String pdfFilePath = filePath + bookUrl;
        //保存文件路径
        String savePath = "";
        int dot = pdfFilePath.lastIndexOf('.');
        if ((dot > -1) && (dot < (pdfFilePath.length()))) {
            savePath = pdfFilePath.substring(0, dot);
        }
        splitPDFOneByOne(pdfFilePath, savePath, bookId, bookName);
    }

    /**
     * //     * @param path       源PDF路径
     * //     * @param fileName   源PDF文件名
     *
     * @param outputPath 拆分后输出的PDF路径
     * @param bookId
     * @Param pathUrl  文件路径
     * @author Reverse_XML
     * 把PDF 按页(逐页、单页)拆分(一页一页拆分，一页为一个新PDF文件)
     */
    public static void splitPDFOneByOne(String pathUrl, String outputPath, String bookId, String bookName) {
        String sep = java.io.File.separator;
        PdfReader reader = null;
        int numberOfPages = 0;
        try {
//            reader = new PdfReader(path + sep + fileName);
            reader = new PdfReader(pathUrl);
            //获取目录结构
            getBookMark(reader, bookId, bookName);
            numberOfPages = reader.getNumberOfPages();
            File filePath = new File(outputPath);
            if (!filePath.exists()) {
                filePath.mkdirs();
            }
            //切成单页jpg文件
            List<String> list = pdfPathToImagePaths(pathUrl, outputPath);
            //切成单页pdf
            for (int i = 1; i <= numberOfPages; i++) {
                Document document = null;
                PdfCopy copy = null;
                try {
                    document = new Document(reader.getPageSize(1));
                    Rectangle pageSize = reader.getPageSize(1);
                    String textFromPage = PdfTextExtractor.getTextFromPage(reader, i);
                    float height = pageSize.getHeight();
                    float width = pageSize.getWidth();
                    String savePath = outputPath + sep + (i - 1) + ".pdf";
                    //fileName.substring(0, fileName.lastIndexOf(".")) + "_" + (i-1) + ".pdf";
                    try {
                        copy = new PdfCopy(document, new FileOutputStream(savePath));
                    } catch (DocumentException e) {
                        e.printStackTrace();
                    }
                    document.open();
                    document.newPage();
                    PdfImportedPage page = copy.getImportedPage(reader, i);
                    copy.addPage(page);
                } finally {
                    if (document != null)
                        document.close();
                    if (copy != null)
                        copy.close();
                }
            }
        } catch (IOException e) {
            System.out.println(e.getMessage());
        } catch (DocumentException e) {
            System.out.println(e.getMessage());
        } finally {
            if (reader != null)
                reader.close();
        }
    }

    /**
     * png文件路径
     *
     * @param pdfPath    pdf完整路径
     * @param outputPath 输出路径
     * @return png集合
     */
    private static List<String> pdfPathToImagePaths(String pdfPath, String outputPath) throws IOException {
        File pdfFile = new File(pdfPath);
        PDDocument pdDocument = PDDocument.load(pdfFile);
        int pageCount = pdDocument.getNumberOfPages();
        PDFRenderer pdfRenderer = new PDFRenderer(pdDocument);
        List<String> imagePathList = new ArrayList<>();
        for (int pageIndex = 0; pageIndex < pageCount; pageIndex++) {
            String imgPath = outputPath + File.separator + pageIndex + ".png";
            BufferedImage image = pdfRenderer.renderImageWithDPI(pageIndex, 72, ImageType.RGB);
            System.out.println(image.getHeight());
            System.out.println(image.getWidth());
            ImageIO.write(image, "png", new File(imgPath));
            imagePathList.add(imgPath);
        }
        pdDocument.close();
        return imagePathList;
    }

    /**
     * 获取目录列表
     *
     * @param pdfReader
     */
    private static void getBookMark(PdfReader pdfReader, String bookId, String bookName) {
        CatalogInfo catalogInfo = new CatalogInfo();
        catalogInfo.setDocumentId(bookId);
        catalogInfo.setId(bookId);
        catalogInfo.setDocumentName(bookName);
        catalogInfo.setTotalPage(pdfReader.getNumberOfPages());
        List<HashMap<String, Object>> list = SimpleBookmark.getBookmark(pdfReader);
        if (list != null) {
            list.forEach(it -> {
                if (it.get("Page") != null) {
                    int j = 1;
                    ChildCatalog childCatalog = new ChildCatalog();
                    //层级
                    childCatalog.setCatalogLevel(j);
                    //目录id
                    childCatalog.setCatalogId(HelpUtil.generateId());
                    childCatalog.setCatalogName(it.get("Title") == null ? "" : it.get("Title").toString());
                    //获取目录 所在 文件 位置
                    String pagePosition = it.get("Page").toString();
                    showBookmark(it, j, childCatalog);
                    getPosition(childCatalog, pagePosition);
                    catalogInfo.getChildCatalogList().add(childCatalog);
                }

            });
        }
    }

    /**
     * @param bookmark 目录
     * @param level    层级
     * @return
     */
    private static ChildCatalog showBookmark(HashMap<String, Object> bookmark, int level, ChildCatalog catalog) {
        //子目录
        ChildCatalog childCatalog = new ChildCatalog();
        //不是第一层级的才新增
        if (level != 1) {
            if(bookmark.get("Page") != null){
                childCatalog.setCatalogName(bookmark.get("Title") != null ? bookmark.get("Title").toString() : "");
                childCatalog.setCatalogId(HelpUtil.generateId());
                childCatalog.setCatalogLevel(level);
                String pagePosition = bookmark.get("Page").toString();
                getPosition(childCatalog, pagePosition);
                catalog.getChildCatalogList().add(childCatalog);
            }
        } else {
            childCatalog = catalog;
        }
        ArrayList kids = (ArrayList) bookmark.get("Kids");
        if (kids != null) {
            level++;
            int finalLevel = level;
            ChildCatalog finalChildCatalog = childCatalog;
            kids.forEach(it -> showBookmark((HashMap<String, Object>) it, finalLevel, finalChildCatalog));
        }
        return catalog;
    }

    /**
     * 获取目录所在 文件位置
     *
     * @param childCatalog 目录记录行
     * @param pagePosition 目录在页面中的位置
     */
    private static void getPosition(ChildCatalog childCatalog, String pagePosition) {
        //页码数据位置
        //34 XYZ 365.35 161.9 0
        String[] s = pagePosition.split(" ");
        //解析出页码
        childCatalog.setPageNum(Integer.valueOf(s[0]));
        //解析出 y 轴坐标
        childCatalog.setPosition(Double.parseDouble(s[3]));

    }
}
