package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.equipmanage.common.entity.vo.BuildingListVO;
import com.yeejoin.equipmanage.common.entity.vo.BuildingVideoListVO;
import com.yeejoin.equipmanage.common.entity.vo.BuildingVideoVO;
import com.yeejoin.equipmanage.common.vo.BuildingTreeVo;
import com.yeejoin.equipmanage.service.IBuilldService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.List;

/**
 * @Description: 消防建筑视屏监控
 * @Author: Wanglulu
 * @Date: 2020/12/22 20:12
 * @Version 0.0.1
 */
@RestController
@Api(tags = "消防建筑视屏监控")
@RequestMapping(value = "/building/video", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class BuildingVideoController extends AbstractBaseController {

    @Autowired
    IBuilldService buildService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("消防建筑视频监控树")
    @GetMapping(value = "/tree")
    public List<BuildingTreeVo> getBuildingTree() {
        return buildService.getBuildingVideoTree();
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("物联监控->单位建筑树（视频节点数量）")
    @GetMapping(value = "/getBuildingVideoTree")
    public List<BuildingTreeVo> getBuildingVideoTree() {
        return buildService.getBuildingVideoTreeNew();
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("消防建筑视屏监控分页列表")
    @GetMapping(value = "/page")
    public Page<BuildingVideoVO> buildingList( Page page, BuildingVideoListVO dto) {
        return buildService.buildingVideoList(page, dto);
    }

    @GetMapping(value = "/fire/equip")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "摄像头关联消防设备")
    public List<BuildingListVO> getFireEquip(@RequestParam Long videoId) {
        return buildService.getFireEquipByVideoId(videoId);
    }

    @GetMapping(value = "/power/equip")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "摄像头关联电力设备")
    public List<BuildingListVO> getEquipBySceneId(@RequestParam Long videoId) {
        return buildService.getPowerEquipByVideoId(videoId);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("安防消防建筑视屏监控树")
    @GetMapping(value = "/cola/tree")
    public List<BuildingTreeVo> getBuildingColaTree() {
        return buildService.getBuildingVideoColaTree();
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("可乐视屏监控分页列表")
    @GetMapping(value = "/cola/page")
    public Page<BuildingVideoVO> buildingColaList(Page page, BuildingVideoListVO dto) {
        if ("0".equals(dto.getBuildingId())) {
            dto.setBuildingId(null);
        }
        String orgCode = getOrgCode();
        dto.setOrgCode(orgCode);
        return buildService.buildingColaVideoList(page, dto);
    }

    @GetMapping(value = "/cola/fire/equip")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "摄像头关联消防设备")
    public List<BuildingListVO> getFireEquipment(@RequestParam Long id) {
        return buildService.getFireEquipment(id);
    }

    @GetMapping(value = "/cola/security/equip")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "摄像头关联安防设备")
    public List<BuildingListVO> getSecurityEquipment(@RequestParam Long id) {
        return buildService.getSecurityEquipment(id);
    }

}
