package com.yeejoin.amos.supervision.business.param;

import java.util.List;
import java.util.Map;

import lombok.Data;

@Data
public class PushMsgParam {

	
	
	/**
	 * 标题
	 */
	private String subject;
	
	
	/**
	 * 消息内容
	 */
	private String content;
	
	
	/**
	 * 邮件地址
	 */
	private String[] emails;
	

	/**
	 * jpush接收人
	 */
	private List<String> recivers;
	

	//	
	/**
	 * jpush参数传递
	 */
	Map<String, String> extras;
	
	/**
	 * jpush发送类型：1：广播；2：标签；3：别名
	 */
	private String type = "3";
	
	private String relationId;

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public List<String> getRecivers() {
		return recivers;
	}

	public void setRecivers(List<String> recivers) {
		this.recivers = recivers;
	}

	public Map<String, String> getExtras() {
		return extras;
	}

	public void setExtras(Map<String, String> extras) {
		this.extras = extras;
	}


	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public String[] getEmails() {
		return emails;
	}

	public void setEmails(String[] emails) {
		this.emails = emails;
	}
	
}
