package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.yeejoin.amos.boot.module.hygf.api.dto.FinancingInfoDto;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.FinancingInfoServiceImpl;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.FinancingRectificationOrderServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.FinancingRectificationOrderDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 投融整改单
 *
 * @author system_generator
 * @date 2024-04-02
 */
@RestController
@Api(tags = "投融整改单Api")
@RequestMapping(value = "/financing-rectification-order")
public class FinancingRectificationOrderController extends BaseController {

    @Autowired
    FinancingRectificationOrderServiceImpl financingRectificationOrderServiceImpl;


    /**
     * 新增投融整改单
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增投融整改单", notes = "新增投融整改单")
	public ResponseModel<FinancingRectificationOrderDto> save(@RequestBody FinancingRectificationOrderDto model) {
	    model = financingRectificationOrderServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新投融整改单", notes = "根据sequenceNbr更新投融整改单")
	public ResponseModel<FinancingRectificationOrderDto> updateBySequenceNbrFinancingRectificationOrder(@RequestBody FinancingRectificationOrderDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
		return ResponseHelper.buildResponse(financingRectificationOrderServiceImpl.updateOrderStatus(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除投融整改单", notes = "根据sequenceNbr删除投融整改单")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(financingRectificationOrderServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个投融整改单",  notes = "根据sequenceNbr查询单个投融整改单")
	public ResponseModel<FinancingRectificationOrderDto> selectOne(@PathVariable Long sequenceNbr) {
		FinancingRectificationOrderDto dto = financingRectificationOrderServiceImpl.queryBySeq(sequenceNbr);
		if (!StringUtils.isEmpty(dto.getRectificationPhoto())){
			dto.setRectificationPhotos(JSONArray.parseArray(dto.getRectificationPhoto()));
		}
		return ResponseHelper.buildResponse(dto);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/problemDescription/{peasantHouseholdId}")
	@ApiOperation(httpMethod = "GET",value = "获取整改问题",  notes = "获取整改问题")
	public ResponseModel<String> getProblemDescription(@PathVariable Long peasantHouseholdId) {

		return ResponseHelper.buildResponse(financingRectificationOrderServiceImpl.getProblemDescription(peasantHouseholdId));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "投融整改单分页查询",  notes = "投融整改单分页查询")
	public ResponseModel<Page<FinancingRectificationOrderDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size,@RequestParam
                    (value = "peasantHouseholdId") Long peasantHouseholdId) {

	    return ResponseHelper.buildResponse(financingRectificationOrderServiceImpl.queryForFinancingRectificationOrderPage( current, size,peasantHouseholdId ));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "投融整改单列表全部数据查询",   notes = "投融整改单列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<FinancingRectificationOrderDto>> selectForList() {
	    return ResponseHelper.buildResponse(financingRectificationOrderServiceImpl.queryForFinancingRectificationOrderList());
	}
}
