package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapBuilder;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.hygf.api.dto.FinancingInfoDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.FinancingAuditing;
import com.yeejoin.amos.boot.module.hygf.api.entity.FinancingRectificationOrder;
import com.yeejoin.amos.boot.module.hygf.api.mapper.FinancingRectificationOrderMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IFinancingRectificationOrderService;
import com.yeejoin.amos.boot.module.hygf.api.dto.FinancingRectificationOrderDto;
import org.apache.activemq.util.MapHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;

/**
 * 投融整改单服务实现类
 *
 * @author system_generator
 * @date 2024-04-02
 */
@Service
public class FinancingRectificationOrderServiceImpl extends BaseService<FinancingRectificationOrderDto,FinancingRectificationOrder,FinancingRectificationOrderMapper> implements IFinancingRectificationOrderService {

    @Autowired
    private FinancingRectificationOrderMapper financingRectificationOrderMapper;
    @Autowired
    FinancingInfoServiceImpl financingInfoServiceImpl;
    @Autowired
    FinancingAuditingServiceImpl financingAuditingService;
    /**
     * 分页查询
     */
    public Page<FinancingRectificationOrderDto> queryForFinancingRectificationOrderPage(int current,int size,Long peasantHouseholdId )   {
        PageHelper.startPage(current,size);
        List<FinancingRectificationOrderDto> list = financingRectificationOrderMapper.selectDataList(peasantHouseholdId);
        PageInfo<FinancingRectificationOrderDto> pageInfo = new PageInfo<>(list);
        Page<FinancingRectificationOrderDto> page = new Page<>();
        page.setSize(pageInfo.getSize());
        page.setCurrent(pageInfo.getPageNum());
        page.setTotal(pageInfo.getTotal());
        page.setRecords(list);

        return page;
    }

    /**
     * 列表查询 示例
     */
    public List<FinancingRectificationOrderDto> queryForFinancingRectificationOrderList()   {
        return this.queryForList("" , false);
    }

    public FinancingRectificationOrderDto  updateOrderStatus(FinancingRectificationOrderDto model){
      if (CollectionUtil.isNotEmpty(model.getRectificationPhotos())){
          model.setRectificationPhoto(JSON.toJSONString(model.getRectificationPhotos()));
      }
        this.updateWithModel(model);

        FinancingInfoDto financingInfoDto = financingInfoServiceImpl.selectDataInfo(model.getPeasantHouseholdId());


        if (model.getRectificationStatus().equals("整改完成")){
            financingInfoServiceImpl.execueFlow(MapBuilder.<String,Object>create().put("instanceId",financingInfoDto.getInstanceId()).put("approvalStatus","0").put("isZG","1").build());
        }else {
            financingInfoDto.setStatus(model.getRectificationStatus());
            financingInfoServiceImpl.updateWithModel(financingInfoDto);
        }
        return model;
    }

    public String getProblemDescription(Long peasantHouseholdId) {
        LambdaQueryWrapper<FinancingRectificationOrder> wrapper = new LambdaQueryWrapper<>();
        wrapper.select(FinancingRectificationOrder::getProblemDescription);
        wrapper.eq(FinancingRectificationOrder::getPeasantHouseholdId,peasantHouseholdId);
        wrapper.orderByDesc(BaseEntity::getRecDate);
        wrapper.last("limit 1");
        FinancingRectificationOrder financingRectificationOrder = this.getBaseMapper().selectOne(wrapper);

        if (null !=financingRectificationOrder){
            return  financingRectificationOrder.getProblemDescription();
        }

        LambdaQueryWrapper<FinancingAuditing> query = new LambdaQueryWrapper<>();
        query.eq(FinancingAuditing::getPeasantHouseholdId,peasantHouseholdId);
        query.orderByDesc(BaseEntity::getRecDate);
        query.last("limit 1");
        FinancingAuditing financingAuditing = financingAuditingService.getBaseMapper().selectOne(query);

        return  financingAuditing.getStatus();

    }
}